/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneReplicaPipelineSafeModeRule
extends SafeModeExitRule<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(OneReplicaPipelineSafeModeRule.class);
    private int thresholdCount;
    private Set<PipelineID> reportedPipelineIDSet = new HashSet<PipelineID>();
    private Set<PipelineID> oldPipelineIDSet;
    private int currentReportedPipelineCount = 0;
    private PipelineManager pipelineManager;

    public OneReplicaPipelineSafeModeRule(String ruleName, EventQueue eventQueue, PipelineManager pipelineManager, SCMSafeModeManager safeModeManager, ConfigurationSource configuration) {
        super(safeModeManager, ruleName, eventQueue);
        double percent = configuration.getDouble("hdds.scm.safemode.atleast.one.node.reported.pipeline.pct", 0.9);
        Preconditions.checkArgument((percent >= 0.0 && percent <= 1.0 ? 1 : 0) != 0, (Object)"hdds.scm.safemode.atleast.one.node.reported.pipeline.pct value should be >= 0.0 and <= 1.0");
        this.pipelineManager = pipelineManager;
        this.oldPipelineIDSet = pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.OPEN).stream().map(p -> p.getId()).collect(Collectors.toSet());
        int totalPipelineCount = this.oldPipelineIDSet.size();
        this.thresholdCount = (int)Math.ceil(percent * (double)totalPipelineCount);
        LOG.info("Total pipeline count is {}, pipeline's with at least one datanode reported threshold count is {}", (Object)totalPipelineCount, (Object)this.thresholdCount);
        this.getSafeModeMetrics().setNumPipelinesWithAtleastOneReplicaReportedThreshold(this.thresholdCount);
    }

    @Override
    protected TypedEvent<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> getEventType() {
        return SCMEvents.PIPELINE_REPORT;
    }

    @Override
    protected boolean validate() {
        return this.currentReportedPipelineCount >= this.thresholdCount;
    }

    @Override
    protected void process(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode report) {
        Preconditions.checkNotNull((Object)report);
        for (StorageContainerDatanodeProtocolProtos.PipelineReport report1 : ((StorageContainerDatanodeProtocolProtos.PipelineReportsProto)report.getReport()).getPipelineReportList()) {
            Pipeline pipeline;
            try {
                pipeline = this.pipelineManager.getPipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)report1.getPipelineID()));
            }
            catch (PipelineNotFoundException pnfe) {
                continue;
            }
            if (pipeline.getType() != HddsProtos.ReplicationType.RATIS || pipeline.getFactor() != HddsProtos.ReplicationFactor.THREE || !pipeline.isOpen() || this.reportedPipelineIDSet.contains(pipeline.getId()) || !this.oldPipelineIDSet.contains(pipeline.getId())) continue;
            this.getSafeModeMetrics().incCurrentHealthyPipelinesWithAtleastOneReplicaReportedCount();
            ++this.currentReportedPipelineCount;
            this.reportedPipelineIDSet.add(pipeline.getId());
        }
        if (this.scmInSafeMode()) {
            SCMSafeModeManager.getLogger().info("SCM in safe mode. Pipelines with at least one datanode reported count is {}, required at least one datanode reported per pipeline count is {}", (Object)this.currentReportedPipelineCount, (Object)this.thresholdCount);
        }
    }

    @Override
    protected void cleanup() {
        this.reportedPipelineIDSet.clear();
    }

    @VisibleForTesting
    public int getThresholdCount() {
        return this.thresholdCount;
    }

    @VisibleForTesting
    public int getCurrentReportedPipelineCount() {
        return this.currentReportedPipelineCount;
    }

    @Override
    public String getStatusText() {
        return String.format("reported Ratis/THREE pipelines with at least one datanode (=%d) >= threshold (=%d)", this.currentReportedPipelineCount, this.thresholdCount);
    }
}

