/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class StorageContainerLocationProtocolServerSideTranslatorPB
implements StorageContainerLocationProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerLocationProtocolServerSideTranslatorPB.class);
    private final StorageContainerLocationProtocol impl;
    private OzoneProtocolMessageDispatcher<StorageContainerLocationProtocolProtos.ScmContainerLocationRequest, StorageContainerLocationProtocolProtos.ScmContainerLocationResponse, ProtocolMessageEnum> dispatcher;

    public StorageContainerLocationProtocolServerSideTranslatorPB(StorageContainerLocationProtocol impl, ProtocolMessageMetrics<ProtocolMessageEnum> protocolMetrics) throws IOException {
        this.impl = impl;
        this.dispatcher = new OzoneProtocolMessageDispatcher("ScmContainerLocation", protocolMetrics, LOG);
    }

    public StorageContainerLocationProtocolProtos.ScmContainerLocationResponse submitRequest(RpcController controller, StorageContainerLocationProtocolProtos.ScmContainerLocationRequest request) throws ServiceException {
        return (StorageContainerLocationProtocolProtos.ScmContainerLocationResponse)this.dispatcher.processRequest((Object)request, this::processRequest, (Object)request.getCmdType(), request.getTraceID());
    }

    public StorageContainerLocationProtocolProtos.ScmContainerLocationResponse processRequest(StorageContainerLocationProtocolProtos.ScmContainerLocationRequest request) throws ServiceException {
        try {
            switch (request.getCmdType()) {
                case AllocateContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setContainerResponse(this.allocateContainer(request.getContainerRequest(), request.getVersion())).build();
                }
                case GetContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerResponse(this.getContainer(request.getGetContainerRequest())).build();
                }
                case GetContainerWithPipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerWithPipelineResponse(this.getContainerWithPipeline(request.getGetContainerWithPipelineRequest(), request.getVersion())).build();
                }
                case GetContainerWithPipelineBatch: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetContainerWithPipelineBatchResponse(this.getContainerWithPipelineBatch(request.getGetContainerWithPipelineBatchRequest(), request.getVersion())).build();
                }
                case ListContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setScmListContainerResponse(this.listContainer(request.getScmListContainerRequest())).build();
                }
                case QueryNode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setNodeQueryResponse(this.queryNode(request.getNodeQueryRequest(), request.getVersion())).build();
                }
                case CloseContainer: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setScmCloseContainerResponse(this.closeContainer(request.getScmCloseContainerRequest())).build();
                }
                case AllocatePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setPipelineResponse(this.allocatePipeline(request.getPipelineRequest(), request.getVersion())).build();
                }
                case ListPipelines: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setListPipelineResponse(this.listPipelines(request.getListPipelineRequest(), request.getVersion())).build();
                }
                case ActivatePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setActivatePipelineResponse(this.activatePipeline(request.getActivatePipelineRequest())).build();
                }
                case DeactivatePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDeactivatePipelineResponse(this.deactivatePipeline(request.getDeactivatePipelineRequest())).build();
                }
                case ClosePipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setClosePipelineResponse(this.closePipeline(request.getClosePipelineRequest())).build();
                }
                case GetScmInfo: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetScmInfoResponse(this.getScmInfo(request.getGetScmInfoRequest())).build();
                }
                case InSafeMode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setInSafeModeResponse(this.inSafeMode(request.getInSafeModeRequest())).build();
                }
                case ForceExitSafeMode: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setForceExitSafeModeResponse(this.forceExitSafeMode(request.getForceExitSafeModeRequest())).build();
                }
                case StartReplicationManager: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStartReplicationManagerResponse(this.startReplicationManager(request.getStartReplicationManagerRequest())).build();
                }
                case StopReplicationManager: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStopReplicationManagerResponse(this.stopReplicationManager(request.getStopReplicationManagerRequest())).build();
                }
                case GetReplicationManagerStatus: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setReplicationManagerStatusResponse(this.getReplicationManagerStatus(request.getSeplicationManagerStatusRequest())).build();
                }
                case GetPipeline: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetPipelineResponse(this.getPipeline(request.getGetPipelineRequest(), request.getVersion())).build();
                }
                case GetSafeModeRuleStatuses: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setGetSafeModeRuleStatusesResponse(this.getSafeModeRuleStatues(request.getGetSafeModeRuleStatusesRequest())).build();
                }
                case DecommissionNodes: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDecommissionNodesResponse(this.decommissionNodes(request.getDecommissionNodesRequest())).build();
                }
                case RecommissionNodes: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setRecommissionNodesResponse(this.recommissionNodes(request.getRecommissionNodesRequest())).build();
                }
                case StartMaintenanceNodes: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setStartMaintenanceNodesResponse(this.startMaintenanceNodes(request.getStartMaintenanceNodesRequest())).build();
                }
                case DatanodeUsageInfo: {
                    return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setDatanodeUsageInfoResponse(this.getDatanodeUsageInfo(request.getDatanodeUsageInfoRequest())).build();
                }
            }
            throw new IllegalArgumentException("Unknown command type: " + request.getCmdType());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public StorageContainerLocationProtocolProtos.ContainerResponseProto allocateContainer(StorageContainerLocationProtocolProtos.ContainerRequestProto request, int clientVersion) throws IOException {
        ContainerWithPipeline cp = this.impl.allocateContainer(request.getReplicationType(), request.getReplicationFactor(), request.getOwner());
        return StorageContainerLocationProtocolProtos.ContainerResponseProto.newBuilder().setContainerWithPipeline(cp.getProtobuf(clientVersion)).setErrorCode(StorageContainerLocationProtocolProtos.ContainerResponseProto.Error.success).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerResponseProto getContainer(StorageContainerLocationProtocolProtos.GetContainerRequestProto request) throws IOException {
        ContainerInfo container = this.impl.getContainer(request.getContainerID());
        return StorageContainerLocationProtocolProtos.GetContainerResponseProto.newBuilder().setContainerInfo(container.getProtobuf()).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto getContainerWithPipeline(StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto request, int clientVersion) throws IOException {
        ContainerWithPipeline container = this.impl.getContainerWithPipeline(request.getContainerID());
        return StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto.newBuilder().setContainerWithPipeline(container.getProtobuf(clientVersion)).build();
    }

    public StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchResponseProto getContainerWithPipelineBatch(StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchRequestProto request, int clientVersion) throws IOException {
        List containers = this.impl.getContainerWithPipelineBatch(request.getContainerIDsList());
        StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchResponseProto.Builder builder = StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchResponseProto.newBuilder();
        for (ContainerWithPipeline container : containers) {
            builder.addContainerWithPipelines(container.getProtobuf(clientVersion));
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.SCMListContainerResponseProto listContainer(StorageContainerLocationProtocolProtos.SCMListContainerRequestProto request) throws IOException {
        long startContainerID = 0L;
        int count = -1;
        if (request.hasStartContainerID()) {
            startContainerID = request.getStartContainerID();
        }
        count = request.getCount();
        HddsProtos.LifeCycleState state = null;
        if (request.hasState()) {
            state = request.getState();
        }
        List containerList = this.impl.listContainer(startContainerID, count, state);
        StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.Builder builder = StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.newBuilder();
        for (ContainerInfo container : containerList) {
            builder.addContainers(container.getProtobuf());
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto deleteContainer(StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto request) throws IOException {
        this.impl.deleteContainer(request.getContainerID());
        return StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.NodeQueryResponseProto queryNode(StorageContainerLocationProtocolProtos.NodeQueryRequestProto request, int clientVersion) throws IOException {
        HddsProtos.NodeOperationalState opState = null;
        HddsProtos.NodeState nodeState = null;
        if (request.hasState()) {
            nodeState = request.getState();
        }
        if (request.hasOpState()) {
            opState = request.getOpState();
        }
        List datanodes = this.impl.queryNode(opState, nodeState, request.getScope(), request.getPoolName(), clientVersion);
        return StorageContainerLocationProtocolProtos.NodeQueryResponseProto.newBuilder().addAllDatanodes((Iterable)datanodes).build();
    }

    public StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto closeContainer(StorageContainerLocationProtocolProtos.SCMCloseContainerRequestProto request) throws IOException {
        this.impl.closeContainer(request.getContainerID());
        return StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.PipelineResponseProto allocatePipeline(StorageContainerLocationProtocolProtos.PipelineRequestProto request, int clientVersion) throws IOException {
        Pipeline pipeline = this.impl.createReplicationPipeline(request.getReplicationType(), request.getReplicationFactor(), HddsProtos.NodePool.getDefaultInstance());
        if (pipeline == null) {
            return StorageContainerLocationProtocolProtos.PipelineResponseProto.newBuilder().setErrorCode(StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.errorPipelineAlreadyExists).build();
        }
        return StorageContainerLocationProtocolProtos.PipelineResponseProto.newBuilder().setErrorCode(StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.success).setPipeline(pipeline.getProtobufMessage(clientVersion)).build();
    }

    public StorageContainerLocationProtocolProtos.ListPipelineResponseProto listPipelines(StorageContainerLocationProtocolProtos.ListPipelineRequestProto request, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.ListPipelineResponseProto.Builder builder = StorageContainerLocationProtocolProtos.ListPipelineResponseProto.newBuilder();
        List pipelines = this.impl.listPipelines();
        for (Pipeline pipeline : pipelines) {
            builder.addPipelines(pipeline.getProtobufMessage(clientVersion));
        }
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.GetPipelineResponseProto getPipeline(StorageContainerLocationProtocolProtos.GetPipelineRequestProto request, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.GetPipelineResponseProto.Builder builder = StorageContainerLocationProtocolProtos.GetPipelineResponseProto.newBuilder();
        Pipeline pipeline = this.impl.getPipeline(request.getPipelineID());
        builder.setPipeline(pipeline.getProtobufMessage(clientVersion));
        return builder.build();
    }

    public StorageContainerLocationProtocolProtos.ActivatePipelineResponseProto activatePipeline(StorageContainerLocationProtocolProtos.ActivatePipelineRequestProto request) throws IOException {
        this.impl.activatePipeline(request.getPipelineID());
        return StorageContainerLocationProtocolProtos.ActivatePipelineResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.DeactivatePipelineResponseProto deactivatePipeline(StorageContainerLocationProtocolProtos.DeactivatePipelineRequestProto request) throws IOException {
        this.impl.deactivatePipeline(request.getPipelineID());
        return StorageContainerLocationProtocolProtos.DeactivatePipelineResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.ClosePipelineResponseProto closePipeline(StorageContainerLocationProtocolProtos.ClosePipelineRequestProto request) throws IOException {
        this.impl.closePipeline(request.getPipelineID());
        return StorageContainerLocationProtocolProtos.ClosePipelineResponseProto.newBuilder().build();
    }

    public HddsProtos.GetScmInfoResponseProto getScmInfo(HddsProtos.GetScmInfoRequestProto req) throws IOException {
        ScmInfo scmInfo = this.impl.getScmInfo();
        return HddsProtos.GetScmInfoResponseProto.newBuilder().setClusterId(scmInfo.getClusterId()).setScmId(scmInfo.getScmId()).build();
    }

    public StorageContainerLocationProtocolProtos.InSafeModeResponseProto inSafeMode(StorageContainerLocationProtocolProtos.InSafeModeRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.InSafeModeResponseProto.newBuilder().setInSafeMode(this.impl.inSafeMode()).build();
    }

    public StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesResponseProto getSafeModeRuleStatues(StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesRequestProto request) throws IOException {
        Map map = this.impl.getSafeModeRuleStatuses();
        ArrayList<StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto> proto = new ArrayList<StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto>();
        for (Map.Entry entry : map.entrySet()) {
            proto.add(StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto.newBuilder().setRuleName((String)entry.getKey()).setValidate(((Boolean)((Pair)entry.getValue()).getLeft()).booleanValue()).setStatusText((String)((Pair)entry.getValue()).getRight()).build());
        }
        return StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesResponseProto.newBuilder().addAllSafeModeRuleStatusesProto(proto).build();
    }

    public StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto forceExitSafeMode(StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto.newBuilder().setExitedSafeMode(this.impl.forceExitSafeMode()).build();
    }

    public StorageContainerLocationProtocolProtos.StartReplicationManagerResponseProto startReplicationManager(StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto request) throws IOException {
        this.impl.startReplicationManager();
        return StorageContainerLocationProtocolProtos.StartReplicationManagerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.StopReplicationManagerResponseProto stopReplicationManager(StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto request) throws IOException {
        this.impl.stopReplicationManager();
        return StorageContainerLocationProtocolProtos.StopReplicationManagerResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto getReplicationManagerStatus(StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto request) throws IOException {
        return StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto.newBuilder().setIsRunning(this.impl.getReplicationManagerStatus()).build();
    }

    public StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto decommissionNodes(StorageContainerLocationProtocolProtos.DecommissionNodesRequestProto request) throws IOException {
        this.impl.decommissionNodes(request.getHostsList());
        return StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto recommissionNodes(StorageContainerLocationProtocolProtos.RecommissionNodesRequestProto request) throws IOException {
        this.impl.recommissionNodes(request.getHostsList());
        return StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto startMaintenanceNodes(StorageContainerLocationProtocolProtos.StartMaintenanceNodesRequestProto request) throws IOException {
        this.impl.startMaintenanceNodes(request.getHostsList(), (int)request.getEndInHours());
        return StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto.newBuilder().build();
    }

    public StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto getDatanodeUsageInfo(StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto request) throws IOException {
        List infoList = request.hasUuid() || request.hasIpaddress() ? this.impl.getDatanodeUsageInfo(request.getIpaddress(), request.getUuid()) : this.impl.getDatanodeUsageInfo(request.getMostUsed(), request.getCount());
        return StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto.newBuilder().addAllInfo((Iterable)infoList).build();
    }
}

