/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMSecurityProtocolServerSideTranslatorPB
implements SCMSecurityProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(SCMSecurityProtocolServerSideTranslatorPB.class);
    private final SCMSecurityProtocol impl;
    private OzoneProtocolMessageDispatcher<SCMSecurityProtocolProtos.SCMSecurityRequest, SCMSecurityProtocolProtos.SCMSecurityResponse, ProtocolMessageEnum> dispatcher;

    public SCMSecurityProtocolServerSideTranslatorPB(SCMSecurityProtocol impl, ProtocolMessageMetrics messageMetrics) {
        this.impl = impl;
        this.dispatcher = new OzoneProtocolMessageDispatcher("ScmSecurityProtocol", messageMetrics, LOG);
    }

    public SCMSecurityProtocolProtos.SCMSecurityResponse submitRequest(RpcController controller, SCMSecurityProtocolProtos.SCMSecurityRequest request) throws ServiceException {
        return (SCMSecurityProtocolProtos.SCMSecurityResponse)this.dispatcher.processRequest((Object)request, this::processRequest, (Object)request.getCmdType(), request.getTraceID());
    }

    public SCMSecurityProtocolProtos.SCMSecurityResponse processRequest(SCMSecurityProtocolProtos.SCMSecurityRequest request) throws ServiceException {
        try {
            switch (request.getCmdType()) {
                case GetCertificate: {
                    return SCMSecurityProtocolProtos.SCMSecurityResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(SCMSecurityProtocolProtos.Status.OK).setGetCertResponseProto(this.getCertificate(request.getGetCertificateRequest())).build();
                }
                case GetCACertificate: {
                    return SCMSecurityProtocolProtos.SCMSecurityResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(SCMSecurityProtocolProtos.Status.OK).setGetCertResponseProto(this.getCACertificate(request.getGetCACertificateRequest())).build();
                }
                case GetOMCertificate: {
                    return SCMSecurityProtocolProtos.SCMSecurityResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(SCMSecurityProtocolProtos.Status.OK).setGetCertResponseProto(this.getOMCertificate(request.getGetOMCertRequest())).build();
                }
                case GetDataNodeCertificate: {
                    return SCMSecurityProtocolProtos.SCMSecurityResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(SCMSecurityProtocolProtos.Status.OK).setGetCertResponseProto(this.getDataNodeCertificate(request.getGetDataNodeCertRequest())).build();
                }
                case ListCertificate: {
                    return SCMSecurityProtocolProtos.SCMSecurityResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(SCMSecurityProtocolProtos.Status.OK).setListCertificateResponseProto(this.listCertificate(request.getListCertificateRequest())).build();
                }
            }
            throw new IllegalArgumentException("Unknown request type: " + request.getCmdType());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getDataNodeCertificate(SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto request) throws IOException {
        String certificate = this.impl.getDataNodeCertificate(request.getDatanodeDetails(), request.getCSR());
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate).setX509CACertificate(this.impl.getCACertificate());
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getOMCertificate(SCMSecurityProtocolProtos.SCMGetOMCertRequestProto request) throws IOException {
        String certificate = this.impl.getOMCertificate(request.getOmDetails(), request.getCSR());
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate).setX509CACertificate(this.impl.getCACertificate());
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCertificate(SCMSecurityProtocolProtos.SCMGetCertificateRequestProto request) throws IOException {
        String certificate = this.impl.getCertificate(request.getCertSerialId());
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate);
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getCACertificate(SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto request) throws IOException {
        String certificate = this.impl.getCACertificate();
        SCMSecurityProtocolProtos.SCMGetCertResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMGetCertResponseProto.ResponseCode.success).setX509Certificate(certificate);
        return builder.build();
    }

    public SCMSecurityProtocolProtos.SCMListCertificateResponseProto listCertificate(SCMSecurityProtocolProtos.SCMListCertificateRequestProto request) throws IOException {
        List certs = this.impl.listCertificate(request.getRole(), request.getStartCertId(), request.getCount(), request.getIsRevoked());
        SCMSecurityProtocolProtos.SCMListCertificateResponseProto.Builder builder = SCMSecurityProtocolProtos.SCMListCertificateResponseProto.newBuilder().setResponseCode(SCMSecurityProtocolProtos.SCMListCertificateResponseProto.ResponseCode.success).addAllCertificates((Iterable)certs);
        return builder.build();
    }
}

