/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.InsufficientDatanodesException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;

public class SimplePipelineProvider
extends PipelineProvider {
    public SimplePipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager) {
        super(nodeManager, stateManager);
    }

    @Override
    public Pipeline create(HddsProtos.ReplicationFactor factor) throws IOException {
        List<DatanodeDetails> dns = this.pickNodesNeverUsed(HddsProtos.ReplicationType.STAND_ALONE, factor);
        if (dns.size() < factor.getNumber()) {
            String e = String.format("Cannot create pipeline of factor %d using %d nodes.", factor.getNumber(), dns.size());
            throw new InsufficientDatanodesException(e);
        }
        Collections.shuffle(dns);
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setType(HddsProtos.ReplicationType.STAND_ALONE).setFactor(factor).setNodes(dns.subList(0, factor.getNumber())).build();
    }

    @Override
    public Pipeline create(HddsProtos.ReplicationFactor factor, List<DatanodeDetails> nodes) {
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setType(HddsProtos.ReplicationType.STAND_ALONE).setFactor(factor).setNodes(nodes).build();
    }

    @Override
    public void close(Pipeline pipeline) throws IOException {
    }

    @Override
    public void shutdown() {
    }
}

