/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineStateManager.class);
    private final PipelineStateMap pipelineStateMap = new PipelineStateMap();

    public void addPipeline(Pipeline pipeline) throws IOException {
        this.pipelineStateMap.addPipeline(pipeline);
        LOG.info("Created pipeline {}", (Object)pipeline);
    }

    void addContainerToPipeline(PipelineID pipelineId, ContainerID containerID) throws IOException {
        this.pipelineStateMap.addContainerToPipeline(pipelineId, containerID);
    }

    public Pipeline getPipeline(PipelineID pipelineID) throws PipelineNotFoundException {
        return this.pipelineStateMap.getPipeline(pipelineID);
    }

    public List<Pipeline> getPipelines() {
        return this.pipelineStateMap.getPipelines();
    }

    List<Pipeline> getPipelines(HddsProtos.ReplicationType type) {
        return this.pipelineStateMap.getPipelines(type);
    }

    List<Pipeline> getPipelines(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) {
        return this.pipelineStateMap.getPipelines(type, factor);
    }

    List<Pipeline> getPipelines(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, Pipeline.PipelineState state) {
        return this.pipelineStateMap.getPipelines(type, factor, state);
    }

    List<Pipeline> getPipelines(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, Pipeline.PipelineState state, Collection<DatanodeDetails> excludeDns, Collection<PipelineID> excludePipelines) {
        return this.pipelineStateMap.getPipelines(type, factor, state, excludeDns, excludePipelines);
    }

    List<Pipeline> getPipelines(HddsProtos.ReplicationType type, Pipeline.PipelineState ... states) {
        return this.pipelineStateMap.getPipelines(type, states);
    }

    NavigableSet<ContainerID> getContainers(PipelineID pipelineID) throws IOException {
        return this.pipelineStateMap.getContainers(pipelineID);
    }

    int getNumberOfContainers(PipelineID pipelineID) throws IOException {
        return this.pipelineStateMap.getNumberOfContainers(pipelineID);
    }

    Pipeline removePipeline(PipelineID pipelineID) throws IOException {
        Pipeline pipeline = this.pipelineStateMap.removePipeline(pipelineID);
        LOG.info("Pipeline {} removed from db", (Object)pipeline);
        return pipeline;
    }

    void removeContainerFromPipeline(PipelineID pipelineID, ContainerID containerID) throws IOException {
        this.pipelineStateMap.removeContainerFromPipeline(pipelineID, containerID);
    }

    Pipeline finalizePipeline(PipelineID pipelineId) throws PipelineNotFoundException {
        Pipeline pipeline = this.pipelineStateMap.getPipeline(pipelineId);
        if (!pipeline.isClosed()) {
            pipeline = this.pipelineStateMap.updatePipelineState(pipelineId, Pipeline.PipelineState.CLOSED);
            LOG.info("Pipeline {} moved to CLOSED state", (Object)pipeline);
        }
        return pipeline;
    }

    Pipeline openPipeline(PipelineID pipelineId) throws IOException {
        Pipeline pipeline = this.pipelineStateMap.getPipeline(pipelineId);
        if (pipeline.isClosed()) {
            throw new IOException("Closed pipeline can not be opened");
        }
        if (pipeline.getPipelineState() == Pipeline.PipelineState.ALLOCATED) {
            LOG.info("Pipeline {} moved to OPEN state", (Object)pipeline);
            pipeline = this.pipelineStateMap.updatePipelineState(pipelineId, Pipeline.PipelineState.OPEN);
        }
        return pipeline;
    }

    public void activatePipeline(PipelineID pipelineID) throws IOException {
        this.pipelineStateMap.updatePipelineState(pipelineID, Pipeline.PipelineState.OPEN);
    }

    public void deactivatePipeline(PipelineID pipelineID) throws IOException {
        this.pipelineStateMap.updatePipelineState(pipelineID, Pipeline.PipelineState.DORMANT);
    }

    public void updatePipelineState(PipelineID id, Pipeline.PipelineState newState) throws PipelineNotFoundException {
        this.pipelineStateMap.updatePipelineState(id, newState);
    }
}

