/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;

public abstract class PipelineProvider {
    private final NodeManager nodeManager;
    private final PipelineStateManager stateManager;

    public PipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager) {
        this.nodeManager = nodeManager;
        this.stateManager = stateManager;
    }

    public PipelineProvider() {
        this.nodeManager = null;
        this.stateManager = null;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public PipelineStateManager getPipelineStateManager() {
        return this.stateManager;
    }

    protected abstract Pipeline create(HddsProtos.ReplicationFactor var1) throws IOException;

    protected abstract Pipeline create(HddsProtos.ReplicationFactor var1, List<DatanodeDetails> var2);

    protected abstract void close(Pipeline var1) throws IOException;

    protected abstract void shutdown();

    List<DatanodeDetails> pickNodesNeverUsed(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) throws SCMException {
        HashSet dnsUsed = new HashSet();
        this.stateManager.getPipelines(type, factor).stream().filter(p -> p.getPipelineState().equals((Object)Pipeline.PipelineState.OPEN) || p.getPipelineState().equals((Object)Pipeline.PipelineState.DORMANT) || p.getPipelineState().equals((Object)Pipeline.PipelineState.ALLOCATED)).forEach(p -> dnsUsed.addAll(p.getNodes()));
        List<DatanodeDetails> dns = this.nodeManager.getNodes(NodeStatus.inServiceHealthy()).parallelStream().filter(dn -> !dnsUsed.contains(dn)).limit(factor.getNumber()).collect(Collectors.toList());
        if (dns.size() < factor.getNumber()) {
            String e = String.format("Cannot create pipeline of factor %d using %d nodes. Used %d nodes. Healthy nodes %d", factor.getNumber(), dns.size(), dnsUsed.size(), this.nodeManager.getNodes(NodeStatus.inServiceHealthy()).size());
            throw new SCMException(e, SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        return dns;
    }
}

