/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManagerMXBean;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.server.events.EventHandler;

public interface PipelineManager
extends Closeable,
PipelineManagerMXBean,
EventHandler<SCMSafeModeManager.SafeModeStatus> {
    public Pipeline createPipeline(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2) throws IOException;

    public Pipeline createPipeline(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2, List<DatanodeDetails> var3);

    public Pipeline getPipeline(PipelineID var1) throws PipelineNotFoundException;

    public boolean containsPipeline(PipelineID var1);

    public List<Pipeline> getPipelines();

    public List<Pipeline> getPipelines(HddsProtos.ReplicationType var1);

    public List<Pipeline> getPipelines(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2);

    public List<Pipeline> getPipelines(HddsProtos.ReplicationType var1, Pipeline.PipelineState var2);

    public List<Pipeline> getPipelines(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2, Pipeline.PipelineState var3);

    public List<Pipeline> getPipelines(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2, Pipeline.PipelineState var3, Collection<DatanodeDetails> var4, Collection<PipelineID> var5);

    public void addContainerToPipeline(PipelineID var1, ContainerID var2) throws IOException;

    public void removeContainerFromPipeline(PipelineID var1, ContainerID var2) throws IOException;

    public NavigableSet<ContainerID> getContainersInPipeline(PipelineID var1) throws IOException;

    public int getNumberOfContainers(PipelineID var1) throws IOException;

    public void openPipeline(PipelineID var1) throws IOException;

    public void finalizeAndDestroyPipeline(Pipeline var1, boolean var2) throws IOException;

    public void scrubPipeline(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2) throws IOException;

    public void startPipelineCreator();

    public void triggerPipelineCreation();

    public void incNumBlocksAllocatedMetric(PipelineID var1);

    public int minHealthyVolumeNum(Pipeline var1);

    public int minPipelineLimit(Pipeline var1);

    public void activatePipeline(PipelineID var1) throws IOException;

    public void deactivatePipeline(PipelineID var1) throws IOException;

    default public void waitPipelineReady(PipelineID pipelineID, long timeout) throws IOException {
    }

    public boolean getSafeModeStatus();
}

