/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeAlreadyExistsException;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;

public class NodeStateMap {
    private final ConcurrentHashMap<UUID, DatanodeInfo> nodeMap;
    private final ConcurrentHashMap<UUID, Set<ContainerID>> nodeToContainer;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public NodeStateMap() {
        this.nodeMap = new ConcurrentHashMap();
        this.nodeToContainer = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(DatanodeDetails datanodeDetails, NodeStatus nodeStatus) throws NodeAlreadyExistsException {
        this.lock.writeLock().lock();
        try {
            UUID id = datanodeDetails.getUuid();
            if (this.nodeMap.containsKey(id)) {
                throw new NodeAlreadyExistsException("Node UUID: " + id);
            }
            this.nodeMap.put(id, new DatanodeInfo(datanodeDetails, nodeStatus));
            this.nodeToContainer.put(id, new HashSet());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatus updateNodeHealthState(UUID nodeId, HddsProtos.NodeState newHealth) throws NodeNotFoundException {
        try {
            this.lock.writeLock().lock();
            DatanodeInfo dn = this.getNodeInfo(nodeId);
            NodeStatus oldStatus = dn.getNodeStatus();
            NodeStatus newStatus = new NodeStatus(oldStatus.getOperationalState(), newHealth);
            dn.setNodeStatus(newStatus);
            NodeStatus nodeStatus = newStatus;
            return nodeStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatus updateNodeOperationalState(UUID nodeId, HddsProtos.NodeOperationalState newOpState, long opStateExpiryEpochSeconds) throws NodeNotFoundException {
        try {
            this.lock.writeLock().lock();
            DatanodeInfo dn = this.getNodeInfo(nodeId);
            NodeStatus oldStatus = dn.getNodeStatus();
            NodeStatus newStatus = new NodeStatus(newOpState, oldStatus.getHealth(), opStateExpiryEpochSeconds);
            dn.setNodeStatus(newStatus);
            NodeStatus nodeStatus = newStatus;
            return nodeStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public DatanodeInfo getNodeInfo(UUID uuid) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            this.checkIfNodeExist(uuid);
            DatanodeInfo datanodeInfo = this.nodeMap.get(uuid);
            return datanodeInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<UUID> getNodes(NodeStatus status) {
        ArrayList<UUID> nodes = new ArrayList<UUID>();
        for (DatanodeInfo dn : this.filterNodes(status)) {
            nodes.add(dn.getUuid());
        }
        return nodes;
    }

    public List<UUID> getNodes(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState health) {
        ArrayList<UUID> nodes = new ArrayList<UUID>();
        for (DatanodeInfo dn : this.filterNodes(opState, health)) {
            nodes.add(dn.getUuid());
        }
        return nodes;
    }

    public List<UUID> getAllNodes() {
        try {
            this.lock.readLock().lock();
            ArrayList<UUID> arrayList = new ArrayList<UUID>(this.nodeMap.keySet());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<DatanodeInfo> getAllDatanodeInfos() {
        try {
            this.lock.readLock().lock();
            ArrayList<DatanodeInfo> arrayList = new ArrayList<DatanodeInfo>(this.nodeMap.values());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<DatanodeInfo> getDatanodeInfos(NodeStatus status) {
        return this.filterNodes(status);
    }

    public List<DatanodeInfo> getDatanodeInfos(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState health) {
        return this.filterNodes(opState, health);
    }

    public int getNodeCount(NodeStatus state) {
        return this.getNodes(state).size();
    }

    public int getNodeCount(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState health) {
        return this.getNodes(opState, health).size();
    }

    public int getTotalNodeCount() {
        this.lock.readLock().lock();
        try {
            int n = this.nodeMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatus getNodeStatus(UUID uuid) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            DatanodeInfo dn = this.nodeMap.get(uuid);
            if (dn == null) {
                throw new NodeNotFoundException("Node not found in node map. UUID: " + uuid);
            }
            NodeStatus nodeStatus = dn.getNodeStatus();
            return nodeStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addContainer(UUID uuid, ContainerID containerId) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            this.checkIfNodeExist(uuid);
            this.nodeToContainer.get(uuid).add(containerId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setContainers(UUID uuid, Set<ContainerID> containers) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            this.checkIfNodeExist(uuid);
            this.nodeToContainer.put(uuid, containers);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<ContainerID> getContainers(UUID uuid) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            this.checkIfNodeExist(uuid);
            Set<ContainerID> set = Collections.unmodifiableSet(new HashSet(this.nodeToContainer.get(uuid)));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void removeContainer(UUID uuid, ContainerID containerID) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            this.checkIfNodeExist(uuid);
            this.nodeToContainer.get(uuid).remove(containerID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Total number of nodes: ").append(this.getTotalNodeCount());
        return builder.toString();
    }

    private void checkIfNodeExist(UUID uuid) throws NodeNotFoundException {
        if (!this.nodeToContainer.containsKey(uuid)) {
            throw new NodeNotFoundException("Node UUID: " + uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DatanodeInfo> filterNodes(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState health) {
        if (opState != null && health != null) {
            return this.filterNodes(new NodeStatus(opState, health));
        }
        if (opState == null && health == null) {
            return this.getAllDatanodeInfos();
        }
        try {
            this.lock.readLock().lock();
            List<DatanodeInfo> list = this.nodeMap.values().stream().filter(n -> opState == null || n.getNodeStatus().getOperationalState() == opState).filter(n -> health == null || n.getNodeStatus().getHealth() == health).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private List<DatanodeInfo> filterNodes(NodeStatus status) {
        try {
            this.lock.readLock().lock();
            List<DatanodeInfo> list = this.nodeMap.values().stream().filter(n -> n.getNodeStatus().equals(status)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

