/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeManagerMXBean;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.ozone.protocol.StorageContainerNodeProtocol;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public interface NodeManager
extends StorageContainerNodeProtocol,
EventHandler<CommandForDatanode>,
NodeManagerMXBean,
Closeable {
    public List<DatanodeDetails> getNodes(NodeStatus var1);

    public List<DatanodeDetails> getNodes(HddsProtos.NodeOperationalState var1, HddsProtos.NodeState var2);

    public int getNodeCount(NodeStatus var1);

    public int getNodeCount(HddsProtos.NodeOperationalState var1, HddsProtos.NodeState var2);

    public List<DatanodeDetails> getAllNodes();

    public SCMNodeStat getStats();

    public Map<DatanodeDetails, SCMNodeStat> getNodeStats();

    public List<DatanodeUsageInfo> getMostOrLeastUsedDatanodes(boolean var1);

    public SCMNodeMetric getNodeStat(DatanodeDetails var1);

    public NodeStatus getNodeStatus(DatanodeDetails var1) throws NodeNotFoundException;

    public void setNodeOperationalState(DatanodeDetails var1, HddsProtos.NodeOperationalState var2) throws NodeNotFoundException;

    public void setNodeOperationalState(DatanodeDetails var1, HddsProtos.NodeOperationalState var2, long var3) throws NodeNotFoundException;

    public Set<PipelineID> getPipelines(DatanodeDetails var1);

    public int getPipelinesCount(DatanodeDetails var1);

    public void addPipeline(Pipeline var1);

    public void removePipeline(Pipeline var1);

    public void addContainer(DatanodeDetails var1, ContainerID var2) throws NodeNotFoundException;

    public void setContainers(DatanodeDetails var1, Set<ContainerID> var2) throws NodeNotFoundException;

    public Set<ContainerID> getContainers(DatanodeDetails var1) throws NodeNotFoundException;

    public void addDatanodeCommand(UUID var1, SCMCommand var2);

    public void processNodeReport(DatanodeDetails var1, StorageContainerDatanodeProtocolProtos.NodeReportProto var2);

    public List<SCMCommand> getCommandQueue(UUID var1);

    public DatanodeDetails getNodeByUuid(String var1);

    public List<DatanodeDetails> getNodesByAddress(String var1);

    public NetworkTopology getClusterNetworkTopologyMap();

    public int minHealthyVolumeNum(List<DatanodeDetails> var1);

    public int pipelineLimit(DatanodeDetails var1);

    public int minPipelineLimit(List<DatanodeDetails> var1);
}

