/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.util.Comparator;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;

public class DatanodeUsageInfo {
    private DatanodeDetails datanodeDetails;
    private SCMNodeStat scmNodeStat;

    public DatanodeUsageInfo(DatanodeDetails datanodeDetails, SCMNodeStat scmNodeStat) {
        this.datanodeDetails = datanodeDetails;
        this.scmNodeStat = scmNodeStat;
    }

    private static int compareByRemainingRatio(DatanodeUsageInfo first, DatanodeUsageInfo second) {
        if (first.equals(second)) {
            return 0;
        }
        return first.getScmNodeStat().compareByRemainingRatio(second.getScmNodeStat());
    }

    public void setDatanodeDetails(DatanodeDetails datanodeDetails) {
        this.datanodeDetails = datanodeDetails;
    }

    public void setScmNodeStat(SCMNodeStat scmNodeStat) {
        this.scmNodeStat = scmNodeStat;
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    public SCMNodeStat getScmNodeStat() {
        return this.scmNodeStat;
    }

    public static Comparator<DatanodeUsageInfo> getMostUsedByRemainingRatio() {
        return DatanodeUsageInfo::compareByRemainingRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatanodeUsageInfo that = (DatanodeUsageInfo)o;
        return this.datanodeDetails.equals((Object)that.datanodeDetails);
    }

    public int hashCode() {
        return this.datanodeDetails.hashCode();
    }

    public HddsProtos.DatanodeUsageInfoProto toProto() {
        return this.toProtoBuilder().build();
    }

    private HddsProtos.DatanodeUsageInfoProto.Builder toProtoBuilder() {
        HddsProtos.DatanodeUsageInfoProto.Builder builder = HddsProtos.DatanodeUsageInfoProto.newBuilder();
        if (this.datanodeDetails != null) {
            builder.setNode(this.datanodeDetails.toProto(this.datanodeDetails.getCurrentVersion()));
        }
        if (this.scmNodeStat != null) {
            builder.setCapacity(this.scmNodeStat.getCapacity().get().longValue());
            builder.setUsed(this.scmNodeStat.getScmUsed().get().longValue());
            builder.setRemaining(this.scmNodeStat.getRemaining().get().longValue());
        }
        return builder;
    }
}

