/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.util.Set;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManager;

public class ContainerReplicaCount {
    private int healthyCount = 0;
    private int decommissionCount = 0;
    private int maintenanceCount = 0;
    private int inFlightAdd = 0;
    private int inFlightDel = 0;
    private int repFactor;
    private int minHealthyForMaintenance;
    private ContainerInfo container;
    private Set<ContainerReplica> replica;

    public ContainerReplicaCount(ContainerInfo container, Set<ContainerReplica> replica, int inFlightAdd, int inFlightDelete, int replicationFactor, int minHealthyForMaintenance) {
        this.inFlightAdd = inFlightAdd;
        this.inFlightDel = inFlightDelete;
        this.repFactor = replicationFactor;
        this.replica = replica;
        this.minHealthyForMaintenance = Math.min(this.repFactor, minHealthyForMaintenance);
        this.container = container;
        for (ContainerReplica cr : this.replica) {
            HddsProtos.NodeOperationalState state = cr.getDatanodeDetails().getPersistedOpState();
            if (state == HddsProtos.NodeOperationalState.DECOMMISSIONED || state == HddsProtos.NodeOperationalState.DECOMMISSIONING) {
                ++this.decommissionCount;
                continue;
            }
            if (state == HddsProtos.NodeOperationalState.IN_MAINTENANCE || state == HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE) {
                ++this.maintenanceCount;
                continue;
            }
            ++this.healthyCount;
        }
    }

    public int getHealthyCount() {
        return this.healthyCount;
    }

    public int getDecommissionCount() {
        return this.decommissionCount;
    }

    public int getMaintenanceCount() {
        return this.maintenanceCount;
    }

    public int getReplicationFactor() {
        return this.repFactor;
    }

    public ContainerInfo getContainer() {
        return this.container;
    }

    public Set<ContainerReplica> getReplica() {
        return this.replica;
    }

    public String toString() {
        return "Container State: " + this.container.getState() + " Replica Count: " + this.replica.size() + " Healthy Count: " + this.healthyCount + " Decommission Count: " + this.decommissionCount + " Maintenance Count: " + this.maintenanceCount + " inFlightAdd Count: " + this.inFlightAdd + " inFightDel Count: " + this.inFlightDel + " ReplicationFactor: " + this.repFactor + " minMaintenance Count: " + this.minHealthyForMaintenance;
    }

    public int additionalReplicaNeeded() {
        int delta = this.missingReplicas();
        if (delta < 0) {
            return delta + this.inFlightDel;
        }
        return Math.max(0, delta - this.inFlightAdd + this.inFlightDel);
    }

    private int missingReplicas() {
        int delta = this.repFactor - this.healthyCount;
        if (delta < 0) {
            return delta;
        }
        if (delta > 0) {
            delta = Math.max(0, delta - this.maintenanceCount);
            int neededHealthy = Math.max(0, this.minHealthyForMaintenance - this.healthyCount);
            delta = Math.max(neededHealthy, delta);
            return delta;
        }
        return delta;
    }

    public boolean isSufficientlyReplicated() {
        return this.missingReplicas() + this.inFlightDel <= 0;
    }

    public boolean isOverReplicated() {
        return this.missingReplicas() + this.inFlightDel < 0;
    }

    public boolean isHealthy() {
        return (this.container.getState() == HddsProtos.LifeCycleState.CLOSED || this.container.getState() == HddsProtos.LifeCycleState.QUASI_CLOSED) && this.replica.stream().filter(r -> r.getDatanodeDetails().getPersistedOpState() == HddsProtos.NodeOperationalState.IN_SERVICE).allMatch(r -> ReplicationManager.compareState(this.container.getState(), r.getState()));
    }
}

