/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.block.DatanodeDeletedBlockTransactions;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.PendingDeleteStatusList;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMBlockDeletingService
extends BackgroundService {
    public static final Logger LOG = LoggerFactory.getLogger(SCMBlockDeletingService.class);
    private static final int BLOCK_DELETING_SERVICE_CORE_POOL_SIZE = 1;
    private final DeletedBlockLog deletedBlockLog;
    private final ContainerManager containerManager;
    private final NodeManager nodeManager;
    private final EventPublisher eventPublisher;
    private int blockDeleteLimitSize;

    public SCMBlockDeletingService(DeletedBlockLog deletedBlockLog, ContainerManager containerManager, NodeManager nodeManager, EventPublisher eventPublisher, Duration interval, long serviceTimeout, ConfigurationSource conf) {
        super("SCMBlockDeletingService", interval.toMillis(), TimeUnit.MILLISECONDS, 1, serviceTimeout);
        this.deletedBlockLog = deletedBlockLog;
        this.containerManager = containerManager;
        this.nodeManager = nodeManager;
        this.eventPublisher = eventPublisher;
        this.blockDeleteLimitSize = ((ScmConfig)conf.getObject(ScmConfig.class)).getBlockDeletionLimit();
        Preconditions.checkArgument((this.blockDeleteLimitSize > 0 ? 1 : 0) != 0, (Object)"Block deletion limit should be positive.");
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new DeletedBlockTransactionScanner());
        return queue;
    }

    void handlePendingDeletes(PendingDeleteStatusList deletionStatusList) {
        DatanodeDetails dnDetails = deletionStatusList.getDatanodeDetails();
        for (PendingDeleteStatusList.PendingDeleteStatus deletionStatus : deletionStatusList.getPendingDeleteStatuses()) {
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Block deletion txnID lagging in datanode {} for containerID {}. Datanode delete txnID: {}, SCM txnID: {}", new Object[]{dnDetails.getUuid(), deletionStatus.getContainerId(), deletionStatus.getDnDeleteTransactionId(), deletionStatus.getScmDeleteTransactionId()});
        }
    }

    @VisibleForTesting
    public void setBlockDeleteTXNum(int numTXs) {
        this.blockDeleteLimitSize = numTXs;
    }

    private class DeletedBlockTransactionScanner
    implements BackgroundTask {
        private DeletedBlockTransactionScanner() {
        }

        public int getPriority() {
            return 1;
        }

        public BackgroundTaskResult.EmptyTaskResult call() throws Exception {
            List<DatanodeDetails> datanodes;
            long startTime = Time.monotonicNow();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running DeletedBlockTransactionScanner");
            }
            if ((datanodes = SCMBlockDeletingService.this.nodeManager.getNodes(NodeStatus.inServiceHealthy())) != null) {
                try {
                    DatanodeDeletedBlockTransactions transactions = SCMBlockDeletingService.this.deletedBlockLog.getTransactions(SCMBlockDeletingService.this.blockDeleteLimitSize);
                    Map<Long, Long> containerIdToMaxTxnId = transactions.getContainerIdToTxnIdMap();
                    if (transactions.isEmpty()) {
                        return BackgroundTaskResult.EmptyTaskResult.newResult();
                    }
                    for (Map.Entry<UUID, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> entry : transactions.getDatanodeTransactionMap().entrySet()) {
                        UUID dnId = entry.getKey();
                        List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> dnTXs = entry.getValue();
                        if (dnTXs.isEmpty()) continue;
                        SCMBlockDeletingService.this.eventPublisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(dnId, (SCMCommand)new DeleteBlocksCommand(dnTXs)));
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Added delete block command for datanode {} in the queue, number of delete block transactions: {}{}", new Object[]{dnId, dnTXs.size(), LOG.isTraceEnabled() ? ", TxID list: " + String.join((CharSequence)",", transactions.getTransactionIDList(dnId)) : ""});
                    }
                    SCMBlockDeletingService.this.containerManager.updateDeleteTransactionId(containerIdToMaxTxnId);
                    LOG.info("Totally added {} blocks to be deleted for {} datanodes, task elapsed time: {}ms", new Object[]{transactions.getBlocksDeleted(), transactions.getDatanodeTransactionMap().size(), Time.monotonicNow() - startTime});
                }
                catch (IOException e) {
                    LOG.error("Failed to get block deletion transactions from delTX log", (Throwable)e);
                    return BackgroundTaskResult.EmptyTaskResult.newResult();
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

