/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.SCMBlockDeletingService;

class DatanodeDeletedBlockTransactions {
    private final Map<UUID, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> transactions = new HashMap<UUID, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>>();
    private int blocksDeleted = 0;
    private final Map<Long, Long> containerIdToTxnId = new HashMap<Long, Long>();

    DatanodeDeletedBlockTransactions() {
    }

    void addTransactionToDN(UUID dnID, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx) {
        this.transactions.computeIfAbsent(dnID, k -> new LinkedList()).add(tx);
        this.containerIdToTxnId.put(tx.getContainerID(), tx.getTxID());
        this.blocksDeleted += tx.getLocalIDCount();
        if (SCMBlockDeletingService.LOG.isDebugEnabled()) {
            SCMBlockDeletingService.LOG.debug("Transaction added: {} <- TX({})", (Object)dnID, (Object)tx.getTxID());
        }
    }

    Map<UUID, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> getDatanodeTransactionMap() {
        return this.transactions;
    }

    Map<Long, Long> getContainerIdToTxnIdMap() {
        return this.containerIdToTxnId;
    }

    int getBlocksDeleted() {
        return this.blocksDeleted;
    }

    List<String> getTransactionIDList(UUID dnId) {
        return ((List)Optional.ofNullable(this.transactions.get(dnId)).orElse(new LinkedList())).stream().map(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction::getTxID).map(String::valueOf).collect(Collectors.toList());
    }

    boolean isEmpty() {
        return this.transactions.isEmpty();
    }
}

