/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.util.StringUtils;
import org.apache.kerby.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AWSV4AuthValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AWSV4AuthValidator.class);
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";

    private AWSV4AuthValidator() {
    }

    private static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hash(String payload) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(payload.getBytes(StandardCharsets.UTF_8));
        return String.format("%064x", new BigInteger(1, md.digest()));
    }

    private static byte[] sign(byte[] key, String msg) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA256_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            mac.init(signingKey);
            return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }

    private static byte[] getSigningKey(String key, String strToSign) {
        String[] signData = StringUtils.split((String)StringUtils.split((String)strToSign, (char)'\n')[2], (char)'/');
        String dateStamp = signData[0];
        String regionName = signData[1];
        String serviceName = signData[2];
        byte[] kDate = AWSV4AuthValidator.sign(("AWS4" + key).getBytes(StandardCharsets.UTF_8), dateStamp);
        byte[] kRegion = AWSV4AuthValidator.sign(kDate, regionName);
        byte[] kService = AWSV4AuthValidator.sign(kRegion, serviceName);
        byte[] kSigning = AWSV4AuthValidator.sign(kService, "aws4_request");
        LOG.info(Hex.encode((byte[])kSigning));
        return kSigning;
    }

    public static boolean validateRequest(String strToSign, String signature, String userKey) {
        String expectedSignature = Hex.encode((byte[])AWSV4AuthValidator.sign(AWSV4AuthValidator.getSigningKey(userKey, strToSign), strToSign));
        return expectedSignature.equals(signature);
    }
}

