/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "deletedTable", "multipartInfoTable"})
public class S3MultipartUploadAbortResponse
extends OMClientResponse {
    private String multipartKey;
    private OmMultipartKeyInfo omMultipartKeyInfo;
    private boolean isRatisEnabled;
    private OmBucketInfo omBucketInfo;

    public S3MultipartUploadAbortResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String multipartKey, @Nonnull OmMultipartKeyInfo omMultipartKeyInfo, boolean isRatisEnabled, @Nonnull OmBucketInfo omBucketInfo) {
        super(omResponse);
        this.multipartKey = multipartKey;
        this.omMultipartKeyInfo = omMultipartKeyInfo;
        this.isRatisEnabled = isRatisEnabled;
        this.omBucketInfo = omBucketInfo;
    }

    public S3MultipartUploadAbortResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getOpenKeyTable().deleteWithBatch(batchOperation, (Object)this.multipartKey);
        omMetadataManager.getMultipartInfoTable().deleteWithBatch(batchOperation, (Object)this.multipartKey);
        TreeMap partKeyInfoMap = this.omMultipartKeyInfo.getPartKeyInfoMap();
        for (Map.Entry partKeyInfoEntry : partKeyInfoMap.entrySet()) {
            OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
            OmKeyInfo currentKeyPartInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)partKeyInfo.getPartName());
            repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)currentKeyPartInfo, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)this.omMultipartKeyInfo.getUpdateID(), (boolean)this.isRatisEnabled);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)partKeyInfo.getPartName(), (Object)repeatedOmKeyInfo);
            omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName()), (Object)this.omBucketInfo);
        }
    }
}

