/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.AbstractOMKeyDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"keyTable"})
public class OMKeysDeleteResponse
extends AbstractOMKeyDeleteResponse {
    private List<OmKeyInfo> omKeyInfoList;
    private OmBucketInfo omBucketInfo;

    public OMKeysDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull List<OmKeyInfo> keyDeleteList, boolean isRatisEnabled, @Nonnull OmBucketInfo omBucketInfo) {
        super(omResponse, isRatisEnabled);
        this.omKeyInfoList = keyDeleteList;
        this.omBucketInfo = omBucketInfo;
    }

    public OMKeysDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    @Override
    public void checkAndUpdateDB(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK || this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.PARTIAL_DELETE) {
            this.addToDBBatch(omMetadataManager, batchOperation);
        }
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String volumeName = "";
        String bucketName = "";
        String keyName = "";
        Table keyTable = omMetadataManager.getKeyTable();
        for (OmKeyInfo omKeyInfo : this.omKeyInfoList) {
            volumeName = omKeyInfo.getVolumeName();
            bucketName = omKeyInfo.getBucketName();
            keyName = omKeyInfo.getKeyName();
            String deleteKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            this.addDeletionToBatch(omMetadataManager, batchOperation, keyTable, deleteKey, omKeyInfo);
        }
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName()), (Object)this.omBucketInfo);
    }
}

