/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeDeleteRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeDeleteRequest.class);

    public OMVolumeDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        deleteVolumeRequest = this.getOmRequest().getDeleteVolumeRequest();
        Preconditions.checkNotNull((Object)deleteVolumeRequest);
        volume = deleteVolumeRequest.getVolumeName();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumVolumeDeletes();
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        omMetadataManager = ozoneManager.getMetadataManager();
        acquiredUserLock = false;
        acquiredVolumeLock = false;
        exception = null;
        owner = null;
        omClientResponse = null;
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, volume, null, null);
            }
            acquiredVolumeLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            omVolumeArgs = this.getVolumeInfo(omMetadataManager, volume);
            owner = omVolumeArgs.getOwnerName();
            acquiredUserLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
            dbUserKey = omMetadataManager.getUserKey(owner);
            dbVolumeKey = omMetadataManager.getVolumeKey(volume);
            if (!omMetadataManager.isVolumeEmpty(volume)) {
                OMVolumeDeleteRequest.LOG.debug("volume:{} is not empty", (Object)volume);
                throw new OMException(OMException.ResultCodes.VOLUME_NOT_EMPTY);
            }
            newVolumeList = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)omMetadataManager.getUserTable().get((Object)owner);
            newVolumeList = this.delVolumeFromOwnerList(newVolumeList, volume, owner, transactionLogIndex);
            omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)dbUserKey), new CacheValue(Optional.of((Object)newVolumeList), transactionLogIndex));
            omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), new CacheValue(Optional.absent(), transactionLogIndex));
            omResponse.setDeleteVolumeResponse(OzoneManagerProtocolProtos.DeleteVolumeResponse.newBuilder().build());
            omClientResponse = new OMVolumeDeleteResponse(omResponse.build(), volume, owner, newVolumeList);
        }
        catch (IOException ex) {
            try {
                exception = ex;
                omClientResponse = new OMVolumeDeleteResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var19_19) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredUserLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                }
                if (acquiredVolumeLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                }
                throw var19_19;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredUserLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
            }
            if (acquiredVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            } else {
                ** GOTO lbl56
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquiredUserLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
        }
        if (acquiredVolumeLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.DELETE_VOLUME, this.buildVolumeAuditMap(volume), exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            OMVolumeDeleteRequest.LOG.debug("Volume deleted for user:{} volume:{}", (Object)owner, (Object)volume);
            omMetrics.decNumVolumes();
        } else {
            OMVolumeDeleteRequest.LOG.error("Volume deletion failed for user:{} volume:{}", new Object[]{owner, volume, exception});
            omMetrics.incNumVolumeDeleteFails();
        }
        return omClientResponse;
    }
}

