/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadAbortResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadAbortRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3MultipartUploadAbortRequest.class);

    public S3MultipartUploadAbortRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = this.getOmRequest().getAbortMultiPartUploadRequest().getKeyArgs();
        return this.getOmRequest().toBuilder().setAbortMultiPartUploadRequest(this.getOmRequest().getAbortMultiPartUploadRequest().toBuilder().setKeyArgs(keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(S3MultipartUploadAbortRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName())))).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        multipartUploadAbortRequest = this.getOmRequest().getAbortMultiPartUploadRequest();
        keyArgs = multipartUploadAbortRequest.getKeyArgs();
        auditMap = this.buildKeyArgsAuditMap(keyArgs);
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        requestedVolume = volumeName;
        requestedBucket = bucketName;
        keyName = keyArgs.getKeyName();
        ozoneManager.getMetrics().incNumAbortMultipartUploads();
        omMetadataManager = ozoneManager.getMetadataManager();
        acquiredLock = false;
        exception = null;
        multipartKeyInfo = null;
        multipartKey = null;
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        omClientResponse = null;
        result = null;
        omBucketInfo = null;
        try {
            keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, OzoneObj.ResourceType.KEY);
            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, keyArgs.getMultipartUploadID());
            omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)multipartKey);
            omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
            if (omKeyInfo == null) {
                throw new OMException("Abort Multipart Upload Failed: volume: " + requestedVolume + "bucket: " + requestedBucket + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
            multipartKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            quotaReleased = 0L;
            keyFactor = omKeyInfo.getFactor().getNumber();
            for (Map.Entry<K, V> entry : multipartKeyInfo.getPartKeyInfoMap().entrySet()) {
                iterPartKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)entry.getValue();
                quotaReleased += iterPartKeyInfo.getPartKeyInfo().getDataSize() * (long)keyFactor;
            }
            omBucketInfo.incrUsedBytes(-quotaReleased);
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.absent(), trxnLogIndex));
            omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.absent(), trxnLogIndex));
            omClientResponse = new S3MultipartUploadAbortResponse(omResponse.setAbortMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartUploadAbortResponse.newBuilder()).build(), multipartKey, multipartKeyInfo, ozoneManager.isRatisEnabled(), omBucketInfo.copyObject());
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            try {
                result = OMClientRequest.Result.FAILURE;
                exception = ex;
                omClientResponse = new S3MultipartUploadAbortResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var29_28) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var29_28;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl62
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.ABORT_MULTIPART_UPLOAD, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                S3MultipartUploadAbortRequest.LOG.debug("Abort Multipart request is successfully completed for KeyName {} in VolumeName/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case 2: {
                ozoneManager.getMetrics().incNumAbortMultipartUploadFails();
                S3MultipartUploadAbortRequest.LOG.error("Abort Multipart request is failed for KeyName {} in VolumeName/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                S3MultipartUploadAbortRequest.LOG.error("Unrecognized Result for S3MultipartUploadAbortRequest: {}", (Object)multipartUploadAbortRequest);
            }
        }
        return omClientResponse;
    }
}

