/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RpcConstants;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.ha.OMNodeDetails;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerStateMachine;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneManagerRatisServer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerRatisServer.class);
    private final int port;
    private final InetSocketAddress omRatisAddress;
    private final RaftServer server;
    private final RaftGroupId raftGroupId;
    private final RaftGroup raftGroup;
    private final RaftPeerId raftPeerId;
    private final OzoneManager ozoneManager;
    private final OzoneManagerStateMachine omStateMachine;

    public OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws ServiceException {
        RaftClientRequest raftClientRequest = this.createWriteRaftClientRequest(omRequest);
        RaftClientReply raftClientReply = this.submitRequestToRatis(raftClientRequest);
        return this.processReply(omRequest, raftClientReply);
    }

    public OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest, RaftClientRequest raftClientRequest) throws ServiceException {
        RaftClientReply raftClientReply = this.submitRequestToRatis(raftClientRequest);
        return this.processReply(omRequest, raftClientReply);
    }

    private RaftClientReply submitRequestToRatis(RaftClientRequest raftClientRequest) throws ServiceException {
        try {
            return (RaftClientReply)this.server.submitClientRequestAsync(raftClientRequest).get();
        }
        catch (Exception ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private RaftClientRequest createWriteRaftClientRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        Preconditions.checkArgument((ProtobufRpcEngine.Server.getClientId() != RpcConstants.DUMMY_CLIENT_ID ? 1 : 0) != 0);
        Preconditions.checkArgument((ProtobufRpcEngine.Server.getCallId() != -2 ? 1 : 0) != 0);
        return RaftClientRequest.newBuilder().setClientId(ClientId.valueOf((UUID)UUID.nameUUIDFromBytes(ProtobufRpcEngine.Server.getClientId()))).setServerId(this.server.getId()).setGroupId(this.raftGroupId).setCallId((long)ProtobufRpcEngine.Server.getCallId()).setMessage(Message.valueOf((ByteString)OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)omRequest))).setType(RaftClientRequest.writeRequestType()).build();
    }

    private OzoneManagerProtocolProtos.OMResponse processReply(OzoneManagerProtocolProtos.OMRequest omRequest, RaftClientReply reply) throws ServiceException {
        if (!reply.isSuccess()) {
            NotLeaderException notLeaderException = reply.getNotLeaderException();
            if (notLeaderException != null) {
                throw new ServiceException((Throwable)OMNotLeaderException.convertToOMNotLeaderException((NotLeaderException)notLeaderException, (RaftPeerId)this.getRaftPeerId()));
            }
            LeaderNotReadyException leaderNotReadyException = reply.getLeaderNotReadyException();
            if (leaderNotReadyException != null) {
                throw new ServiceException((Throwable)new OMLeaderNotReadyException(leaderNotReadyException.getMessage()));
            }
            StateMachineException stateMachineException = reply.getStateMachineException();
            if (stateMachineException != null) {
                OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(omRequest.getCmdType()).setSuccess(false).setTraceID(omRequest.getTraceID());
                if (stateMachineException.getCause() != null) {
                    omResponse.setMessage(stateMachineException.getCause().getMessage());
                    omResponse.setStatus(this.exceptionToResponseStatus(stateMachineException.getCause()));
                } else {
                    LOG.error("StateMachine exception cause is not set");
                    omResponse.setStatus(OzoneManagerProtocolProtos.Status.INTERNAL_ERROR);
                    omResponse.setMessage(StringUtils.stringifyException((Throwable)stateMachineException));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error while executing ratis request. stateMachineException: ", (Throwable)stateMachineException);
                }
                return omResponse.build();
            }
        }
        try {
            return OMRatisHelper.getOMResponseFromRaftClientReply((RaftClientReply)reply);
        }
        catch (InvalidProtocolBufferException ex) {
            if (ex.getMessage() != null) {
                throw new ServiceException(ex.getMessage(), (Throwable)ex);
            }
            throw new ServiceException((Throwable)ex);
        }
    }

    private OzoneManagerProtocolProtos.Status exceptionToResponseStatus(Throwable cause) {
        if (cause instanceof OMException) {
            return OzoneManagerProtocolProtos.Status.values()[((OMException)cause).getResult().ordinal()];
        }
        LOG.error("Unknown error occurs", cause);
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }

    private OzoneManagerRatisServer(ConfigurationSource conf, OzoneManager om, String raftGroupIdStr, RaftPeerId localRaftPeerId, InetSocketAddress addr, List<RaftPeer> raftPeers, SecurityConfig secConfig, CertificateClient certClient) throws IOException {
        this.ozoneManager = om;
        this.omRatisAddress = addr;
        this.port = addr.getPort();
        RaftProperties serverProperties = this.newRaftProperties(conf);
        this.raftPeerId = localRaftPeerId;
        this.raftGroupId = RaftGroupId.valueOf((UUID)this.getRaftGroupIdFromOmServiceId(raftGroupIdStr));
        this.raftGroup = RaftGroup.valueOf((RaftGroupId)this.raftGroupId, raftPeers);
        StringBuilder raftPeersStr = new StringBuilder();
        for (RaftPeer peer : raftPeers) {
            raftPeersStr.append(", ").append(peer.getAddress());
        }
        LOG.info("Instantiating OM Ratis server with GroupID: {} and Raft Peers: {}", (Object)raftGroupIdStr, (Object)raftPeersStr.toString().substring(2));
        this.omStateMachine = this.getStateMachine(conf);
        Parameters parameters = OzoneManagerRatisServer.createServerTlsParameters(secConfig, certClient);
        this.server = RaftServer.newBuilder().setServerId(this.raftPeerId).setGroup(this.raftGroup).setProperties(serverProperties).setParameters(parameters).setStateMachine((StateMachine)this.omStateMachine).build();
    }

    public static OzoneManagerRatisServer newOMRatisServer(ConfigurationSource ozoneConf, OzoneManager omProtocol, OMNodeDetails omNodeDetails, List<OMNodeDetails> peerNodes, SecurityConfig secConfig, CertificateClient certClient) throws IOException {
        String omServiceId = omNodeDetails.getOMServiceId();
        String omNodeId = omNodeDetails.getOMNodeId();
        RaftPeerId localRaftPeerId = RaftPeerId.getRaftPeerId((String)omNodeId);
        InetSocketAddress ratisAddr = new InetSocketAddress(omNodeDetails.getInetAddress(), omNodeDetails.getRatisPort());
        RaftPeer localRaftPeer = RaftPeer.newBuilder().setId(localRaftPeerId).setAddress(ratisAddr).build();
        ArrayList<RaftPeer> raftPeers = new ArrayList<RaftPeer>();
        raftPeers.add(localRaftPeer);
        for (OMNodeDetails peerInfo : peerNodes) {
            RaftPeer raftPeer;
            String peerNodeId = peerInfo.getOMNodeId();
            RaftPeerId raftPeerId = RaftPeerId.valueOf((String)peerNodeId);
            if (peerInfo.isHostUnresolved()) {
                raftPeer = RaftPeer.newBuilder().setId(raftPeerId).setAddress(peerInfo.getRatisHostPortStr()).build();
            } else {
                InetSocketAddress peerRatisAddr = new InetSocketAddress(peerInfo.getInetAddress(), peerInfo.getRatisPort());
                raftPeer = RaftPeer.newBuilder().setId(raftPeerId).setAddress(peerRatisAddr).build();
            }
            raftPeers.add(raftPeer);
        }
        return new OzoneManagerRatisServer(ozoneConf, omProtocol, omServiceId, localRaftPeerId, ratisAddr, raftPeers, secConfig, certClient);
    }

    public RaftGroup getRaftGroup() {
        return this.raftGroup;
    }

    @VisibleForTesting
    public RaftServer getServer() {
        return this.server;
    }

    private OzoneManagerStateMachine getStateMachine(ConfigurationSource conf) throws IOException {
        return new OzoneManagerStateMachine(this, TracingUtil.isTracingEnabled((ConfigurationSource)conf));
    }

    @VisibleForTesting
    public OzoneManagerStateMachine getOmStateMachine() {
        return this.omStateMachine;
    }

    public OzoneManager getOzoneManager() {
        return this.ozoneManager;
    }

    public void start() throws IOException {
        LOG.info("Starting {} {} at port {}", new Object[]{this.getClass().getSimpleName(), this.server.getId(), this.port});
        this.server.start();
    }

    public void stop() {
        try {
            this.server.close();
            this.omStateMachine.stop();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RaftProperties newRaftProperties(ConfigurationSource conf) {
        RaftProperties properties = new RaftProperties();
        String rpcType = conf.get("ozone.om.ratis.rpc.type", "GRPC");
        SupportedRpcType rpc = SupportedRpcType.valueOfIgnoreCase((String)rpcType);
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpc);
        if (rpc == SupportedRpcType.GRPC) {
            GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)this.port);
        } else if (rpc == SupportedRpcType.NETTY) {
            NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)this.port);
        }
        String storageDir = OzoneManagerRatisServer.getOMRatisDirectory(conf);
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, Collections.singletonList(new File(storageDir)));
        RaftServerConfigKeys.LeaderElection.setPreVote((RaftProperties)properties, (boolean)false);
        int raftSegmentSize = (int)conf.getStorageSize("ozone.om.ratis.segment.size", "4MB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentSize));
        RaftServerConfigKeys.Log.setPurgeUptoSnapshotIndex((RaftProperties)properties, (boolean)true);
        int raftSegmentPreallocatedSize = (int)conf.getStorageSize("ozone.om.ratis.segment.preallocated.size", "4MB", StorageUnit.BYTES);
        int logAppenderQueueNumElements = conf.getInt("ozone.om.ratis.log.appender.queue.num-elements", 1024);
        int logAppenderQueueByteLimit = (int)conf.getStorageSize("ozone.om.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)properties, (int)logAppenderQueueNumElements);
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentPreallocatedSize));
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)properties, (boolean)false);
        int logPurgeGap = conf.getInt("ozone.om.ratis.log.purge.gap", 1000000);
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)properties, (int)logPurgeGap);
        GrpcConfigKeys.setMessageSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        TimeUnit serverRequestTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_REQUEST_TIMEOUT_DEFAULT.getUnit();
        long serverRequestTimeoutDuration = conf.getTimeDuration("ozone.om.ratis.server.request.timeout", OMConfigKeys.OZONE_OM_RATIS_SERVER_REQUEST_TIMEOUT_DEFAULT.getDuration(), serverRequestTimeoutUnit);
        TimeDuration serverRequestTimeout = TimeDuration.valueOf((long)serverRequestTimeoutDuration, (TimeUnit)serverRequestTimeoutUnit);
        RaftServerConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)serverRequestTimeout);
        TimeUnit retryCacheTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DEFAULT.getUnit();
        long retryCacheTimeoutDuration = conf.getTimeDuration("ozone.om.ratis.server.retry.cache.timeout", OMConfigKeys.OZONE_OM_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DEFAULT.getDuration(), retryCacheTimeoutUnit);
        TimeDuration retryCacheTimeout = TimeDuration.valueOf((long)retryCacheTimeoutDuration, (TimeUnit)retryCacheTimeoutUnit);
        RaftServerConfigKeys.RetryCache.setExpiryTime((RaftProperties)properties, (TimeDuration)retryCacheTimeout);
        TimeUnit serverMinTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_MINIMUM_TIMEOUT_DEFAULT.getUnit();
        long serverMinTimeoutDuration = conf.getTimeDuration("ozone.om.ratis.minimum.timeout", OMConfigKeys.OZONE_OM_RATIS_MINIMUM_TIMEOUT_DEFAULT.getDuration(), serverMinTimeoutUnit);
        TimeDuration serverMinTimeout = TimeDuration.valueOf((long)serverMinTimeoutDuration, (TimeUnit)serverMinTimeoutUnit);
        long serverMaxTimeoutDuration = serverMinTimeout.toLong(TimeUnit.MILLISECONDS) + 200L;
        TimeDuration serverMaxTimeout = TimeDuration.valueOf((long)serverMaxTimeoutDuration, (TimeUnit)TimeUnit.MILLISECONDS);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)serverMinTimeout);
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)serverMaxTimeout);
        RaftServerConfigKeys.Log.setSegmentCacheNumMax((RaftProperties)properties, (int)2);
        TimeUnit nodeFailureTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_FAILURE_TIMEOUT_DURATION_DEFAULT.getUnit();
        long nodeFailureTimeoutDuration = conf.getTimeDuration("ozone.om.ratis.server.failure.timeout.duration", OMConfigKeys.OZONE_OM_RATIS_SERVER_FAILURE_TIMEOUT_DURATION_DEFAULT.getDuration(), nodeFailureTimeoutUnit);
        TimeDuration nodeFailureTimeout = TimeDuration.valueOf((long)nodeFailureTimeoutDuration, (TimeUnit)nodeFailureTimeoutUnit);
        RaftServerConfigKeys.Notification.setNoLeaderTimeout((RaftProperties)properties, (TimeDuration)nodeFailureTimeout);
        RaftServerConfigKeys.Rpc.setSlownessTimeout((RaftProperties)properties, (TimeDuration)nodeFailureTimeout);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)properties, (boolean)true);
        long snapshotAutoTriggerThreshold = conf.getLong("ozone.om.ratis.snapshot.auto.trigger.threshold", 400000L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)properties, (long)snapshotAutoTriggerThreshold);
        this.createRaftServerProperties(conf, properties);
        return properties;
    }

    private void createRaftServerProperties(ConfigurationSource ozoneConf, RaftProperties raftProperties) {
        Map<String, String> ratisServerConf = OzoneManagerRatisServer.getOMHAConfigs(ozoneConf);
        ratisServerConf.forEach((key, val) -> raftProperties.set(key, val));
    }

    private static Map<String, String> getOMHAConfigs(ConfigurationSource configuration) {
        return configuration.getPropsWithPrefix("ozone.om.ha.");
    }

    public RaftServerStatus checkLeaderStatus() {
        try {
            RaftServer.Division division = this.server.getDivision(this.raftGroupId);
            if (division != null) {
                if (!division.getInfo().isLeader()) {
                    return RaftServerStatus.NOT_LEADER;
                }
                if (division.getInfo().isLeaderReady()) {
                    return RaftServerStatus.LEADER_AND_READY;
                }
                return RaftServerStatus.LEADER_AND_NOT_READY;
            }
        }
        catch (IOException ioe) {
            LOG.error("Fail to get RaftServer impl and therefore it's not clear whether it's leader. ", (Throwable)ioe);
        }
        return RaftServerStatus.NOT_LEADER;
    }

    public int getServerPort() {
        return this.port;
    }

    @VisibleForTesting
    public LifeCycle.State getServerState() {
        return this.server.getLifeCycleState();
    }

    @VisibleForTesting
    public RaftPeerId getRaftPeerId() {
        return this.raftPeerId;
    }

    private UUID getRaftGroupIdFromOmServiceId(String omServiceId) {
        return UUID.nameUUIDFromBytes(omServiceId.getBytes(StandardCharsets.UTF_8));
    }

    public static String getOMRatisDirectory(ConfigurationSource conf) {
        String storageDir = conf.get("ozone.om.ratis.storage.dir");
        if (Strings.isNullOrEmpty((String)storageDir)) {
            storageDir = ServerUtils.getDefaultRatisDirectory((ConfigurationSource)conf);
        }
        return storageDir;
    }

    public static String getOMRatisSnapshotDirectory(ConfigurationSource conf) {
        String snapshotDir = conf.get("ozone.om.ratis.snapshot.dir");
        if (Strings.isNullOrEmpty((String)snapshotDir)) {
            LOG.warn("{} is not configured. Falling back to {} config", (Object)"ozone.om.ratis.snapshot.dir", (Object)"ozone.metadata.dirs");
            File metaDirPath = ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf);
            snapshotDir = Paths.get(metaDirPath.getPath(), "snapshot").toString();
        }
        return snapshotDir;
    }

    public TermIndex getLastAppliedTermIndex() {
        return this.omStateMachine.getLastAppliedTermIndex();
    }

    public RaftGroupId getRaftGroupId() {
        return this.raftGroupId;
    }

    private static Parameters createServerTlsParameters(SecurityConfig conf, CertificateClient caClient) {
        Parameters parameters = new Parameters();
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            GrpcTlsConfig config = new GrpcTlsConfig(caClient.getPrivateKey(), caClient.getCertificate(), caClient.getCACertificate(), true);
            GrpcConfigKeys.Server.setTlsConf((Parameters)parameters, (GrpcTlsConfig)config);
            GrpcConfigKeys.Admin.setTlsConf((Parameters)parameters, (GrpcTlsConfig)config);
            GrpcConfigKeys.Client.setTlsConf((Parameters)parameters, (GrpcTlsConfig)config);
            GrpcConfigKeys.TLS.setConf((Parameters)parameters, (GrpcTlsConfig)config);
        }
        return parameters;
    }

    public static enum RaftServerStatus {
        NOT_LEADER,
        LEADER_AND_NOT_READY,
        LEADER_AND_READY;

    }
}

