/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.om.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenKeyCleanupService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(OpenKeyCleanupService.class);
    private static final int OPEN_KEY_DELETING_CORE_POOL_SIZE = 2;
    private final KeyManager keyManager;
    private final ScmBlockLocationProtocol scmClient;

    public OpenKeyCleanupService(ScmBlockLocationProtocol scmClient, KeyManager keyManager, int serviceInterval, long serviceTimeout) {
        super("OpenKeyCleanupService", (long)serviceInterval, TimeUnit.SECONDS, 2, serviceTimeout);
        this.keyManager = keyManager;
        this.scmClient = scmClient;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new OpenKeyDeletingTask());
        return queue;
    }

    private class OpenKeyDeletingTask
    implements BackgroundTask {
        private OpenKeyDeletingTask() {
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() throws Exception {
            try {
                OpenKeyCleanupService.this.keyManager.getExpiredOpenKeys(0);
            }
            catch (IOException e) {
                LOG.error("Unable to get hanging open keys, retry in next interval", (Throwable)e);
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

