/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.hadoop.ozone.recon.schema.tables.daos.GlobalStatsDao;
import org.hadoop.ozone.recon.schema.tables.pojos.GlobalStats;
import org.jooq.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCountTask
implements ReconOmTask {
    private static final Logger LOG = LoggerFactory.getLogger(TableCountTask.class);
    private GlobalStatsDao globalStatsDao;
    private Configuration sqlConfiguration;
    private ReconOMMetadataManager reconOMMetadataManager;

    @Inject
    public TableCountTask(GlobalStatsDao globalStatsDao, Configuration sqlConfiguration, ReconOMMetadataManager reconOMMetadataManager) {
        this.globalStatsDao = globalStatsDao;
        this.sqlConfiguration = sqlConfiguration;
        this.reconOMMetadataManager = reconOMMetadataManager;
    }

    @Override
    public Pair<String, Boolean> reprocess(OMMetadataManager omMetadataManager) {
        for (String tableName : this.getTaskTables()) {
            Table table = omMetadataManager.getTable(tableName);
            try {
                TableIterator keyIter = table.iterator();
                Throwable throwable = null;
                try {
                    long count = this.getCount((Iterator)keyIter);
                    ReconUtils.upsertGlobalStatsTable(this.sqlConfiguration, this.globalStatsDao, TableCountTask.getRowKeyFromTable(tableName), count);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (keyIter == null) continue;
                    if (throwable != null) {
                        try {
                            keyIter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    keyIter.close();
                }
            }
            catch (IOException ioEx) {
                LOG.error("Unable to populate Table Count in Recon DB.", (Throwable)ioEx);
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
        }
        LOG.info("Completed a 'reprocess' run of TableCountTask.");
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    private long getCount(Iterator iterator) {
        long count = 0L;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    @Override
    public String getTaskName() {
        return "TableCountTask";
    }

    public Collection<String> getTaskTables() {
        return new ArrayList<String>(this.reconOMMetadataManager.listTableNames());
    }

    @Override
    public Pair<String, Boolean> process(OMUpdateEventBatch events) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        HashMap<String, Long> objectCountMap = this.initializeCountMap();
        Collection<String> taskTables = this.getTaskTables();
        block6: while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            if (!taskTables.contains(omdbUpdateEvent.getTable())) continue;
            String rowKey = TableCountTask.getRowKeyFromTable(omdbUpdateEvent.getTable());
            try {
                switch (omdbUpdateEvent.getAction()) {
                    case PUT: {
                        objectCountMap.computeIfPresent(rowKey, (k, count) -> count + 1L);
                        break;
                    }
                    case DELETE: {
                        if (omdbUpdateEvent.getValue() == null) continue block6;
                        String key = TableCountTask.getRowKeyFromTable(omdbUpdateEvent.getTable());
                        objectCountMap.computeIfPresent(key, (k, count) -> count > 0L ? count - 1L : 0L);
                        break;
                    }
                    default: {
                        LOG.trace("Skipping DB update event : Table: {}, Action: {}", (Object)omdbUpdateEvent.getTable(), (Object)omdbUpdateEvent.getAction());
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while processing the table {}, Action: {}", new Object[]{omdbUpdateEvent.getTable(), omdbUpdateEvent.getAction(), e});
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
        }
        for (Map.Entry<String, Long> entry : objectCountMap.entrySet()) {
            ReconUtils.upsertGlobalStatsTable(this.sqlConfiguration, this.globalStatsDao, entry.getKey(), entry.getValue());
        }
        LOG.info("Completed a 'process' run of TableCountTask.");
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    private HashMap<String, Long> initializeCountMap() {
        Collection<String> tables = this.getTaskTables();
        HashMap<String, Long> objectCountMap = new HashMap<String, Long>(tables.size());
        for (String tableName : tables) {
            String key = TableCountTask.getRowKeyFromTable(tableName);
            objectCountMap.put(key, this.getCountForKey(key));
        }
        return objectCountMap;
    }

    public static String getRowKeyFromTable(String tableName) {
        return tableName + "Count";
    }

    private long getCountForKey(String key) {
        GlobalStats record = this.globalStatsDao.fetchOneByKey(key);
        return record == null ? 0L : record.getValue();
    }
}

