/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDBUpdatesHandler
extends WriteBatch.Handler {
    private static final Logger LOG = LoggerFactory.getLogger(OMDBUpdatesHandler.class);
    private Map<Integer, String> tablesNames;
    private CodecRegistry codecRegistry;
    private OMMetadataManager omMetadataManager;
    private List<OMDBUpdateEvent> omdbUpdateEvents = new ArrayList<OMDBUpdateEvent>();
    private OMDBDefinition omdbDefinition;

    public OMDBUpdatesHandler(OMMetadataManager metadataManager) {
        this.omMetadataManager = metadataManager;
        this.tablesNames = metadataManager.getStore().getTableNames();
        this.codecRegistry = metadataManager.getStore().getCodecRegistry();
        this.omdbDefinition = new OMDBDefinition();
    }

    public void put(int cfIndex, byte[] keyBytes, byte[] valueBytes) {
        try {
            this.processEvent(cfIndex, keyBytes, valueBytes, OMDBUpdateEvent.OMDBUpdateAction.PUT);
        }
        catch (IOException ioEx) {
            LOG.error("Exception when reading key : ", (Throwable)ioEx);
        }
    }

    public void delete(int cfIndex, byte[] keyBytes) {
        try {
            this.processEvent(cfIndex, keyBytes, null, OMDBUpdateEvent.OMDBUpdateAction.DELETE);
        }
        catch (IOException ioEx) {
            LOG.error("Exception when reading key : ", (Throwable)ioEx);
        }
    }

    private void processEvent(int cfIndex, byte[] keyBytes, byte[] valueBytes, OMDBUpdateEvent.OMDBUpdateAction action) throws IOException {
        String tableName = this.tablesNames.get(cfIndex);
        Optional keyType = this.omdbDefinition.getKeyType(tableName);
        Optional valueType = this.omdbDefinition.getValueType(tableName);
        if (keyType.isPresent() && valueType.isPresent()) {
            OMDBUpdateEvent.OMUpdateEventBuilder<String, Object> builder = new OMDBUpdateEvent.OMUpdateEventBuilder<String, Object>();
            builder.setTable(tableName);
            builder.setAction(action);
            String key = (String)this.codecRegistry.asObject(keyBytes, (Class)keyType.get());
            builder.setKey(key);
            Table table = this.omMetadataManager.getTable(tableName);
            Object oldValue = table.getSkipCache((Object)key);
            if (action == OMDBUpdateEvent.OMDBUpdateAction.PUT) {
                Object value = this.codecRegistry.asObject(valueBytes, (Class)valueType.get());
                builder.setValue(value);
                if (oldValue != null) {
                    builder.setOldValue(oldValue);
                    builder.setAction(OMDBUpdateEvent.OMDBUpdateAction.UPDATE);
                }
            } else if (action.equals((Object)OMDBUpdateEvent.OMDBUpdateAction.DELETE)) {
                builder.setValue(oldValue);
            }
            OMDBUpdateEvent event = builder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Generated OM update Event for table : %s, action = %s", new Object[]{tableName, action}));
            }
            if (this.omdbUpdateEvents.contains(event)) {
                this.omdbUpdateEvents.remove(event);
            }
            this.omdbUpdateEvents.add(event);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn(String.format("KeyType or ValueType could not be determined for table %s. Ignoring the event.", tableName));
        }
    }

    public void put(byte[] bytes, byte[] bytes1) {
    }

    public void merge(int i, byte[] bytes, byte[] bytes1) throws RocksDBException {
    }

    public void merge(byte[] bytes, byte[] bytes1) {
    }

    public void delete(byte[] bytes) {
    }

    public void singleDelete(int i, byte[] bytes) throws RocksDBException {
    }

    public void singleDelete(byte[] bytes) {
    }

    public void deleteRange(int i, byte[] bytes, byte[] bytes1) throws RocksDBException {
    }

    public void deleteRange(byte[] bytes, byte[] bytes1) {
    }

    public void logData(byte[] bytes) {
    }

    public void putBlobIndex(int i, byte[] bytes, byte[] bytes1) throws RocksDBException {
    }

    public void markBeginPrepare() throws RocksDBException {
    }

    public void markEndPrepare(byte[] bytes) throws RocksDBException {
    }

    public void markNoop(boolean b) throws RocksDBException {
    }

    public void markRollback(byte[] bytes) throws RocksDBException {
    }

    public void markCommit(byte[] bytes) throws RocksDBException {
    }

    public List<OMDBUpdateEvent> getEvents() {
        return this.omdbUpdateEvents;
    }
}

