/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import org.hadoop.ozone.recon.schema.tables.daos.ReconTaskStatusDao;
import org.hadoop.ozone.recon.schema.tables.pojos.ReconTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReconScmTask {
    private static final Logger LOG = LoggerFactory.getLogger(ReconScmTask.class);
    private Thread taskThread;
    private ReconTaskStatusDao reconTaskStatusDao;
    private volatile boolean running;

    protected ReconScmTask(ReconTaskStatusDao reconTaskStatusDao) {
        this.reconTaskStatusDao = reconTaskStatusDao;
    }

    private void register() {
        String taskName = this.getTaskName();
        if (!this.reconTaskStatusDao.existsById(taskName)) {
            ReconTaskStatus reconTaskStatusRecord = new ReconTaskStatus(taskName, 0L, 0L);
            this.reconTaskStatusDao.insert(reconTaskStatusRecord);
            LOG.info("Registered {} task ", (Object)taskName);
        }
    }

    public synchronized void start() {
        this.register();
        if (!this.isRunning()) {
            LOG.info("Starting {} Thread.", (Object)this.getTaskName());
            this.running = true;
            this.taskThread = new Thread(this::run);
            this.taskThread.setName(this.getTaskName());
            this.taskThread.setDaemon(true);
            this.taskThread.start();
        } else {
            LOG.info("{} Thread is already running.", (Object)this.getTaskName());
        }
    }

    public synchronized void stop() {
        if (this.running) {
            LOG.info("Stopping {} Thread.", (Object)this.getTaskName());
            this.running = false;
            this.notifyAll();
        } else {
            LOG.info("{} Thread is not running.", (Object)this.getTaskName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        if (!this.running) {
            ReconScmTask reconScmTask = this;
            synchronized (reconScmTask) {
                return this.taskThread != null && this.taskThread.isAlive();
            }
        }
        return true;
    }

    protected void recordSingleRunCompletion() {
        this.reconTaskStatusDao.update(new ReconTaskStatus(this.getTaskName(), System.currentTimeMillis(), 0L));
    }

    protected boolean canRun() {
        return this.running;
    }

    public String getTaskName() {
        return this.getClass().getSimpleName();
    }

    protected abstract void run();
}

