/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineReportHandler;
import org.apache.hadoop.hdds.scm.safemode.SafeModeManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconPipelineReportHandler
extends PipelineReportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReconPipelineReportHandler.class);
    private StorageContainerServiceProvider scmServiceProvider;

    public ReconPipelineReportHandler(SafeModeManager scmSafeModeManager, PipelineManager pipelineManager, ConfigurationSource conf, StorageContainerServiceProvider scmServiceProvider) {
        super(scmSafeModeManager, pipelineManager, conf);
        this.scmServiceProvider = scmServiceProvider;
    }

    protected void processPipelineReport(StorageContainerDatanodeProtocolProtos.PipelineReport report, DatanodeDetails dn, EventPublisher publisher) throws IOException {
        PipelineID pipelineID;
        ReconPipelineManager reconPipelineManager = (ReconPipelineManager)this.getPipelineManager();
        if (!reconPipelineManager.containsPipeline(pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)report.getPipelineID()))) {
            LOG.info("Unknown pipeline {}. Trying to get from SCM.", (Object)pipelineID);
            Pipeline pipelineFromScm = this.scmServiceProvider.getPipeline(report.getPipelineID());
            LOG.info("Adding new pipeline {} to Recon pipeline metadata.", (Object)pipelineFromScm);
            reconPipelineManager.addPipeline(pipelineFromScm);
        }
        Pipeline pipeline = null;
        try {
            pipeline = reconPipelineManager.getPipeline(pipelineID);
        }
        catch (PipelineNotFoundException ex) {
            LOG.warn("Pipeline {} not found in Recon.", (Object)pipelineID);
            return;
        }
        this.setReportedDatanode(pipeline, dn);
        this.setPipelineLeaderId(report, pipeline, dn);
        if (pipeline.getPipelineState() == Pipeline.PipelineState.ALLOCATED) {
            LOG.info("Pipeline {} {} reported by {}", new Object[]{pipeline.getFactor(), pipeline.getId(), dn});
            if (pipeline.isHealthy()) {
                reconPipelineManager.openPipeline(pipelineID);
            }
        }
    }
}

