/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconNodeManager
extends SCMNodeManager {
    public static final Logger LOG = LoggerFactory.getLogger(ReconNodeManager.class);
    private Table<UUID, DatanodeDetails> nodeDB;
    private static final Set<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type> ALLOWED_COMMANDS = ImmutableSet.of((Object)StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reregisterCommand);
    private Map<UUID, Long> datanodeHeartbeatMap = new HashMap<UUID, Long>();

    public ReconNodeManager(OzoneConfiguration conf, SCMStorageConfig scmStorageConfig, EventPublisher eventPublisher, NetworkTopology networkTopology, Table<UUID, DatanodeDetails> nodeDB) {
        super(conf, scmStorageConfig, eventPublisher, networkTopology);
        this.nodeDB = nodeDB;
        this.loadExistingNodes();
    }

    private void loadExistingNodes() {
        try {
            int nodeCount = 0;
            TableIterator iterator = this.nodeDB.iterator();
            while (iterator.hasNext()) {
                DatanodeDetails datanodeDetails = (DatanodeDetails)((Table.KeyValue)iterator.next()).getValue();
                this.register(datanodeDetails, null, null);
                ++nodeCount;
            }
            LOG.info("Loaded {} nodes from node DB.", (Object)nodeCount);
        }
        catch (IOException ioEx) {
            LOG.error("Exception while loading existing nodes.", (Throwable)ioEx);
        }
    }

    public void addNodeToDB(DatanodeDetails datanodeDetails) throws IOException {
        this.nodeDB.put((Object)datanodeDetails.getUuid(), (Object)datanodeDetails);
        LOG.info("Adding new node {} to Node DB.", (Object)datanodeDetails.getUuid());
    }

    public long getLastHeartbeat(DatanodeDetails datanodeDetails) {
        return this.datanodeHeartbeatMap.getOrDefault(datanodeDetails.getUuid(), 0L);
    }

    public void onMessage(CommandForDatanode commandForDatanode, EventPublisher ignored) {
        StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type cmdType = commandForDatanode.getCommand().getType();
        if (ALLOWED_COMMANDS.contains(cmdType)) {
            super.onMessage(commandForDatanode, ignored);
        } else {
            LOG.debug("Ignoring unsupported command {} for Datanode {}.", (Object)cmdType, (Object)commandForDatanode.getDatanodeId());
        }
    }

    public List<SCMCommand> processHeartbeat(DatanodeDetails datanodeDetails) {
        this.datanodeHeartbeatMap.put(datanodeDetails.getUuid(), Time.now());
        List cmds = super.processHeartbeat(datanodeDetails);
        return cmds.stream().filter(c -> ALLOWED_COMMANDS.contains(c.getType())).collect(Collectors.toList());
    }

    protected void updateDatanodeOpState(DatanodeDetails reportedDn) throws NodeNotFoundException {
        super.updateDatanodeOpState(reportedDn);
        super.getNodeStateManager().setNodeOperationalState(reportedDn, reportedDn.getPersistedOpState(), reportedDn.getPersistedOpStateExpiryEpochSec());
    }
}

