/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import java.util.List;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.apache.hadoop.ozone.recon.scm.ReconScmTask;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskConfig;
import org.apache.hadoop.util.Time;
import org.hadoop.ozone.recon.schema.tables.daos.ReconTaskStatusDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineSyncTask
extends ReconScmTask {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineSyncTask.class);
    private StorageContainerServiceProvider scmClient;
    private ReconPipelineManager reconPipelineManager;
    private final long interval;

    public PipelineSyncTask(ReconPipelineManager pipelineManager, StorageContainerServiceProvider scmClient, ReconTaskStatusDao reconTaskStatusDao, ReconTaskConfig reconTaskConfig) {
        super(reconTaskStatusDao);
        this.scmClient = scmClient;
        this.reconPipelineManager = pipelineManager;
        this.interval = reconTaskConfig.getPipelineSyncTaskInterval().toMillis();
    }

    @Override
    protected synchronized void run() {
        try {
            while (this.canRun()) {
                long start = Time.monotonicNow();
                List<Pipeline> pipelinesFromScm = this.scmClient.getPipelines();
                this.reconPipelineManager.initializePipelines(pipelinesFromScm);
                LOG.info("Pipeline sync Thread took {} milliseconds.", (Object)(Time.monotonicNow() - start));
                this.recordSingleRunCompletion();
                this.wait(this.interval);
            }
        }
        catch (Throwable t) {
            LOG.error("Exception in Pipeline sync Thread.", t);
        }
    }
}

