/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.recovery;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconOmMetadataManagerImpl
extends OmMetadataManagerImpl
implements ReconOMMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconOmMetadataManagerImpl.class);
    private OzoneConfiguration ozoneConfiguration;
    private ReconUtils reconUtils;
    private boolean omTablesInitialized = false;

    @Inject
    public ReconOmMetadataManagerImpl(OzoneConfiguration configuration, ReconUtils reconUtils) {
        this.reconUtils = reconUtils;
        this.ozoneConfiguration = configuration;
    }

    public void start(OzoneConfiguration configuration) throws IOException {
        LOG.info("Starting ReconOMMetadataManagerImpl");
        File reconDbDir = this.reconUtils.getReconDbDir((ConfigurationSource)configuration, "ozone.recon.om.db.dir");
        File lastKnownOMSnapshot = this.reconUtils.getLastKnownDB(reconDbDir, "om.snapshot.db");
        if (lastKnownOMSnapshot != null) {
            LOG.info("Last known snapshot for OM : {}", (Object)lastKnownOMSnapshot.getAbsolutePath());
            this.initializeNewRdbStore(lastKnownOMSnapshot);
        }
    }

    private void initializeNewRdbStore(File dbFile) throws IOException {
        try {
            DBStoreBuilder dbStoreBuilder = DBStoreBuilder.newBuilder((ConfigurationSource)this.ozoneConfiguration).setName(dbFile.getName()).setPath(dbFile.toPath().getParent());
            ReconOmMetadataManagerImpl.addOMTablesAndCodecs((DBStoreBuilder)dbStoreBuilder);
            DBStore newStore = dbStoreBuilder.build();
            this.setStore(newStore);
            LOG.info("Created OM DB handle from snapshot at {}.", (Object)dbFile.getAbsolutePath());
        }
        catch (IOException ioEx) {
            LOG.error("Unable to initialize Recon OM DB snapshot store.", (Throwable)ioEx);
        }
        if (this.getStore() != null) {
            this.initializeOmTables();
            this.omTablesInitialized = true;
        }
    }

    @Override
    public void updateOmDB(File newDbLocation) throws IOException {
        File oldDBLocation;
        if (this.getStore() != null && (oldDBLocation = this.getStore().getDbLocation()).exists()) {
            LOG.info("Cleaning up old OM snapshot db at {}.", (Object)oldDBLocation.getAbsolutePath());
            FileUtils.deleteDirectory((File)oldDBLocation);
        }
        this.initializeNewRdbStore(newDbLocation);
    }

    @Override
    public long getLastSequenceNumberFromDB() {
        RDBStore rocksDBStore = (RDBStore)this.getStore();
        if (null == rocksDBStore) {
            return 0L;
        }
        return rocksDBStore.getDb().getLatestSequenceNumber();
    }

    @Override
    public boolean isOmTablesInitialized() {
        return this.omTablesInitialized;
    }
}

