/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.fsck;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;

public class ContainerHealthStatus {
    private ContainerInfo container;
    private int replicaDelta;
    private Set<ContainerReplica> replicas;
    private ContainerPlacementStatus placementStatus;

    ContainerHealthStatus(ContainerInfo container, Set<ContainerReplica> replicas, PlacementPolicy placementPolicy) {
        this.container = container;
        int repFactor = container.getReplicationFactor().getNumber();
        this.replicas = replicas.stream().filter(r -> !r.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY)).collect(Collectors.toSet());
        this.replicaDelta = repFactor - this.replicas.size();
        this.placementStatus = this.getPlacementStatus(placementPolicy, repFactor);
    }

    public long getContainerID() {
        return this.container.getContainerID();
    }

    public ContainerInfo getContainer() {
        return this.container;
    }

    public int getReplicationFactor() {
        return this.container.getReplicationFactor().getNumber();
    }

    public boolean isHealthy() {
        return this.replicaDelta == 0 && !this.isMisReplicated();
    }

    public boolean isOverReplicated() {
        return this.replicaDelta < 0;
    }

    public boolean isUnderReplicated() {
        return !this.isMissing() && this.replicaDelta > 0;
    }

    public int replicaDelta() {
        return this.replicaDelta;
    }

    public int getReplicaCount() {
        return this.replicas.size();
    }

    public boolean isMisReplicated() {
        return !this.isMissing() && !this.placementStatus.isPolicySatisfied();
    }

    public int misReplicatedDelta() {
        return this.placementStatus.misReplicationCount();
    }

    public int expectedPlacementCount() {
        return this.placementStatus.expectedPlacementCount();
    }

    public int actualPlacementCount() {
        return this.placementStatus.actualPlacementCount();
    }

    public String misReplicatedReason() {
        return this.placementStatus.misReplicatedReason();
    }

    public boolean isMissing() {
        return this.replicas.size() == 0;
    }

    private ContainerPlacementStatus getPlacementStatus(PlacementPolicy policy, int repFactor) {
        List dns = this.replicas.stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList());
        return policy.validateContainerPlacement(dns, repFactor);
    }
}

