/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.recon.api.types.DatanodeMetadata;
import org.apache.hadoop.ozone.recon.api.types.DatanodePipeline;
import org.apache.hadoop.ozone.recon.api.types.DatanodeStorageReport;
import org.apache.hadoop.ozone.recon.api.types.DatanodesResponse;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/datanodes")
@Produces(value={"application/json"})
public class NodeEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(NodeEndpoint.class);
    private ReconNodeManager nodeManager;
    private ReconPipelineManager pipelineManager;

    @Inject
    NodeEndpoint(OzoneStorageContainerManager reconSCM) {
        this.nodeManager = (ReconNodeManager)reconSCM.getScmNodeManager();
        this.pipelineManager = (ReconPipelineManager)reconSCM.getPipelineManager();
    }

    @GET
    public Response getDatanodes() {
        ArrayList<DatanodeMetadata> datanodes = new ArrayList<DatanodeMetadata>();
        List datanodeDetails = this.nodeManager.getAllNodes();
        datanodeDetails.forEach(datanode -> {
            DatanodeStorageReport storageReport = this.getStorageReport((DatanodeDetails)datanode);
            HddsProtos.NodeState nodeState = null;
            try {
                nodeState = this.nodeManager.getNodeStatus((DatanodeDetails)datanode).getHealth();
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Cannot get nodeState for datanode {}", datanode, (Object)e);
            }
            HddsProtos.NodeOperationalState nodeOpState = datanode.getPersistedOpState();
            String hostname = datanode.getHostName();
            Set pipelineIDs = this.nodeManager.getPipelines((DatanodeDetails)datanode);
            ArrayList<DatanodePipeline> pipelines = new ArrayList<DatanodePipeline>();
            AtomicInteger leaderCount = new AtomicInteger();
            DatanodeMetadata.Builder builder = DatanodeMetadata.newBuilder();
            pipelineIDs.forEach(pipelineID -> {
                try {
                    Pipeline pipeline = this.pipelineManager.getPipeline((PipelineID)pipelineID);
                    String leaderNode = pipeline.getLeaderNode().getHostName();
                    DatanodePipeline datanodePipeline = new DatanodePipeline(pipelineID.getId(), pipeline.getType().toString(), pipeline.getFactor().getNumber(), leaderNode);
                    pipelines.add(datanodePipeline);
                    if (datanode.getUuid().equals(pipeline.getLeaderId())) {
                        leaderCount.getAndIncrement();
                    }
                }
                catch (PipelineNotFoundException ex) {
                    LOG.warn("Cannot get pipeline {} for datanode {}, pipeline not found", new Object[]{pipelineID.getId(), hostname, ex});
                }
                catch (IOException ioEx) {
                    LOG.warn("Cannot get leader node of pipeline with id {}.", (Object)pipelineID.getId(), (Object)ioEx);
                }
            });
            try {
                int containers = this.nodeManager.getContainers((DatanodeDetails)datanode).size();
                builder.withContainers(containers);
            }
            catch (NodeNotFoundException ex) {
                LOG.warn("Cannot get containers, datanode {} not found.", (Object)datanode.getUuid(), (Object)ex);
            }
            datanodes.add(builder.withHostname(hostname).withDatanodeStorageReport(storageReport).withLastHeartbeat(this.nodeManager.getLastHeartbeat((DatanodeDetails)datanode)).withState(nodeState).withOperationalState(nodeOpState).withPipelines(pipelines).withLeaderCount(leaderCount.get()).withUUid(datanode.getUuidString()).withVersion(datanode.getVersion()).withSetupTime(datanode.getSetupTime()).withRevision(datanode.getRevision()).withBuildDate(datanode.getBuildDate()).build());
        });
        DatanodesResponse datanodesResponse = new DatanodesResponse(datanodes.size(), datanodes);
        return Response.ok((Object)datanodesResponse).build();
    }

    private DatanodeStorageReport getStorageReport(DatanodeDetails datanode) {
        SCMNodeStat nodeStat = this.nodeManager.getNodeStat(datanode).get();
        long capacity = nodeStat.getCapacity().get();
        long used = nodeStat.getScmUsed().get();
        long remaining = nodeStat.getRemaining().get();
        return new DatanodeStorageReport(capacity, used, remaining);
    }
}

