/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.recon.api.types.ContainerKeyPrefix;
import org.apache.hadoop.ozone.recon.api.types.ContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.ContainersResponse;
import org.apache.hadoop.ozone.recon.api.types.KeyMetadata;
import org.apache.hadoop.ozone.recon.api.types.KeysResponse;
import org.apache.hadoop.ozone.recon.api.types.MissingContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.MissingContainersResponse;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainersResponse;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainersSummary;
import org.apache.hadoop.ozone.recon.persistence.ContainerHealthSchemaManager;
import org.apache.hadoop.ozone.recon.persistence.ContainerHistory;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.spi.ContainerDBServiceProvider;
import org.hadoop.ozone.recon.schema.ContainerSchemaDefinition;
import org.hadoop.ozone.recon.schema.tables.pojos.UnhealthyContainers;

@Path(value="/containers")
@Produces(value={"application/json"})
public class ContainerEndpoint {
    @Inject
    private ContainerDBServiceProvider containerDBServiceProvider;
    @Inject
    private ReconOMMetadataManager omMetadataManager;
    private final ReconContainerManager containerManager;
    private final ContainerHealthSchemaManager containerHealthSchemaManager;

    @Inject
    public ContainerEndpoint(OzoneStorageContainerManager reconSCM, ContainerHealthSchemaManager containerHealthSchemaManager) {
        this.containerManager = (ReconContainerManager)reconSCM.getContainerManager();
        this.containerHealthSchemaManager = containerHealthSchemaManager;
    }

    @GET
    public Response getContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey) {
        long containersCount;
        Map<Long, ContainerMetadata> containersMap;
        try {
            containersMap = this.containerDBServiceProvider.getContainers(limit, prevKey);
            containersCount = this.containerDBServiceProvider.getCountForContainers();
        }
        catch (IOException ioEx) {
            throw new WebApplicationException((Throwable)ioEx, Response.Status.INTERNAL_SERVER_ERROR);
        }
        ContainersResponse containersResponse = new ContainersResponse(containersCount, containersMap.values());
        return Response.ok((Object)containersResponse).build();
    }

    @GET
    @Path(value="/{id}/keys")
    public Response getKeysForContainer(@PathParam(value="id") Long containerID, @DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKeyPrefix) {
        long totalCount;
        LinkedHashMap<String, KeyMetadata> keyMetadataMap = new LinkedHashMap<String, KeyMetadata>();
        try {
            Map<ContainerKeyPrefix, Integer> containerKeyPrefixMap = this.containerDBServiceProvider.getKeyPrefixesForContainer(containerID, prevKeyPrefix);
            for (ContainerKeyPrefix containerKeyPrefix : containerKeyPrefixMap.keySet()) {
                OmKeyInfo omKeyInfo = (OmKeyInfo)this.omMetadataManager.getKeyTable().getSkipCache((Object)containerKeyPrefix.getKeyPrefix());
                if (null == omKeyInfo) continue;
                List<OmKeyLocationInfoGroup> matchedKeys = omKeyInfo.getKeyLocationVersions().stream().filter(k -> k.getVersion() == containerKeyPrefix.getKeyVersion()).collect(Collectors.toList());
                List<KeyMetadata.ContainerBlockMetadata> blockIds = this.getBlocks(matchedKeys, containerID);
                String ozoneKey = this.omMetadataManager.getOzoneKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), omKeyInfo.getKeyName());
                if (keyMetadataMap.containsKey(ozoneKey)) {
                    ((KeyMetadata)keyMetadataMap.get(ozoneKey)).getVersions().add(containerKeyPrefix.getKeyVersion());
                    ((KeyMetadata)keyMetadataMap.get(ozoneKey)).getBlockIds().put(containerKeyPrefix.getKeyVersion(), blockIds);
                    continue;
                }
                if (keyMetadataMap.size() == limit) break;
                KeyMetadata keyMetadata = new KeyMetadata();
                keyMetadata.setBucket(omKeyInfo.getBucketName());
                keyMetadata.setVolume(omKeyInfo.getVolumeName());
                keyMetadata.setKey(omKeyInfo.getKeyName());
                keyMetadata.setCreationTime(Instant.ofEpochMilli(omKeyInfo.getCreationTime()));
                keyMetadata.setModificationTime(Instant.ofEpochMilli(omKeyInfo.getModificationTime()));
                keyMetadata.setDataSize(omKeyInfo.getDataSize());
                keyMetadata.getVersions().add(containerKeyPrefix.getKeyVersion());
                keyMetadataMap.put(ozoneKey, keyMetadata);
                keyMetadata.getBlockIds().put(containerKeyPrefix.getKeyVersion(), blockIds);
            }
            totalCount = this.containerDBServiceProvider.getKeyCountForContainer(containerID);
        }
        catch (IOException ioEx) {
            throw new WebApplicationException((Throwable)ioEx, Response.Status.INTERNAL_SERVER_ERROR);
        }
        KeysResponse keysResponse = new KeysResponse(totalCount, keyMetadataMap.values());
        return Response.ok((Object)keysResponse).build();
    }

    @GET
    @Path(value="/{id}/replicaHistory")
    public Response getReplicaHistoryForContainer(@PathParam(value="id") Long containerID) {
        return Response.ok(this.containerManager.getAllContainerHistory(containerID)).build();
    }

    @GET
    @Path(value="/missing")
    public Response getMissingContainers() {
        ArrayList<MissingContainerMetadata> missingContainers = new ArrayList<MissingContainerMetadata>();
        this.containerHealthSchemaManager.getUnhealthyContainers(ContainerSchemaDefinition.UnHealthyContainerStates.MISSING, 0, Integer.MAX_VALUE).forEach(container -> {
            long containerID = container.getContainerId();
            try {
                ContainerInfo containerInfo = this.containerManager.getContainer(new ContainerID(containerID));
                long keyCount = containerInfo.getNumberOfKeys();
                UUID pipelineID = containerInfo.getPipelineID().getId();
                List<ContainerHistory> datanodes = this.containerManager.getLatestContainerHistory(containerID, containerInfo.getReplicationFactor().getNumber());
                missingContainers.add(new MissingContainerMetadata(containerID, container.getInStateSince(), keyCount, pipelineID, datanodes));
            }
            catch (IOException ioEx) {
                throw new WebApplicationException((Throwable)ioEx, Response.Status.INTERNAL_SERVER_ERROR);
            }
        });
        MissingContainersResponse response = new MissingContainersResponse(missingContainers.size(), missingContainers);
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/unhealthy/{state}")
    public Response getUnhealthyContainers(@PathParam(value="state") String state, @DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="1") @QueryParam(value="batchNum") int batchNum) {
        List<UnhealthyContainersSummary> summary;
        int offset = Math.max((batchNum - 1) * limit, 0);
        ArrayList<UnhealthyContainerMetadata> unhealthyMeta = new ArrayList<UnhealthyContainerMetadata>();
        try {
            ContainerSchemaDefinition.UnHealthyContainerStates internalState = null;
            if (state != null) {
                internalState = ContainerSchemaDefinition.UnHealthyContainerStates.valueOf((String)state);
            }
            summary = this.containerHealthSchemaManager.getUnhealthyContainersSummary();
            List<UnhealthyContainers> containers = this.containerHealthSchemaManager.getUnhealthyContainers(internalState, offset, limit);
            for (UnhealthyContainers c : containers) {
                long containerID = c.getContainerId();
                ContainerInfo containerInfo = this.containerManager.getContainer(new ContainerID(containerID));
                long keyCount = containerInfo.getNumberOfKeys();
                UUID pipelineID = containerInfo.getPipelineID().getId();
                List<ContainerHistory> datanodes = this.containerManager.getLatestContainerHistory(containerID, containerInfo.getReplicationFactor().getNumber());
                unhealthyMeta.add(new UnhealthyContainerMetadata(c, datanodes, pipelineID, keyCount));
            }
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        UnhealthyContainersResponse response = new UnhealthyContainersResponse(unhealthyMeta);
        for (UnhealthyContainersSummary s : summary) {
            response.setSummaryCount(s.getContainerState(), s.getCount());
        }
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/unhealthy")
    public Response getUnhealthyContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="1") @QueryParam(value="batchNum") int batchNum) {
        return this.getUnhealthyContainers(null, limit, batchNum);
    }

    private List<KeyMetadata.ContainerBlockMetadata> getBlocks(List<OmKeyLocationInfoGroup> matchedKeys, long containerID) {
        ArrayList<KeyMetadata.ContainerBlockMetadata> blockIds = new ArrayList<KeyMetadata.ContainerBlockMetadata>();
        for (OmKeyLocationInfoGroup omKeyLocationInfoGroup : matchedKeys) {
            List omKeyLocationInfos = omKeyLocationInfoGroup.getLocationList().stream().filter(c -> c.getContainerID() == containerID).collect(Collectors.toList());
            for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfos) {
                blockIds.add(new KeyMetadata.ContainerBlockMetadata(omKeyLocationInfo.getContainerID(), omKeyLocationInfo.getLocalID()));
            }
        }
        return blockIds;
    }
}

