/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.recon.ReconConfig;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.recon.ConfigurationProvider;
import org.apache.hadoop.ozone.recon.ReconControllerModule;
import org.apache.hadoop.ozone.recon.ReconGuiceServletContextListener;
import org.apache.hadoop.ozone.recon.ReconHttpServer;
import org.apache.hadoop.ozone.recon.ReconRestServletModule;
import org.apache.hadoop.ozone.recon.ReconSchemaManager;
import org.apache.hadoop.ozone.recon.spi.ContainerDBServiceProvider;
import org.apache.hadoop.ozone.recon.spi.OzoneManagerServiceProvider;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.hadoop.ozone.recon.codegen.ReconSchemaGenerationModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconServer
extends GenericCli {
    private static final Logger LOG = LoggerFactory.getLogger(ReconServer.class);
    private Injector injector;
    private ReconHttpServer httpServer;
    private ContainerDBServiceProvider containerDBServiceProvider;
    private OzoneManagerServiceProvider ozoneManagerServiceProvider;
    private OzoneStorageContainerManager reconStorageContainerManager;
    private OzoneConfiguration configuration;
    private volatile boolean isStarted = false;

    public static void main(String[] args) {
        new ReconServer().run(args);
    }

    public Void call() throws Exception {
        String[] originalArgs = this.getCmd().getParseResult().originalArgs().toArray(new String[0]);
        StringUtils.startupShutdownMessage((VersionInfo)OzoneVersionInfo.OZONE_VERSION_INFO, ReconServer.class, (String[])originalArgs, (Logger)LOG);
        this.configuration = this.createOzoneConfiguration();
        ConfigurationProvider.setConfiguration(this.configuration);
        this.injector = Guice.createInjector((Module[])new Module[]{new ReconControllerModule(), new ReconRestServletModule(){

            @Override
            protected void configureServlets() {
                this.rest("/api/v1/*").packages("org.apache.hadoop.ozone.recon.api");
            }
        }, new ReconSchemaGenerationModule()});
        ReconGuiceServletContextListener.setInjector(this.injector);
        LOG.info("Initializing Recon server...");
        try {
            ReconServer.loginReconUserIfSecurityEnabled(this.configuration);
            this.containerDBServiceProvider = (ContainerDBServiceProvider)this.injector.getInstance(ContainerDBServiceProvider.class);
            ReconSchemaManager reconSchemaManager = (ReconSchemaManager)this.injector.getInstance(ReconSchemaManager.class);
            LOG.info("Creating Recon Schema.");
            reconSchemaManager.createReconSchema();
            this.httpServer = (ReconHttpServer)((Object)this.injector.getInstance(ReconHttpServer.class));
            this.ozoneManagerServiceProvider = (OzoneManagerServiceProvider)this.injector.getInstance(OzoneManagerServiceProvider.class);
            this.reconStorageContainerManager = (OzoneStorageContainerManager)this.injector.getInstance(OzoneStorageContainerManager.class);
            LOG.info("Recon server initialized successfully!");
        }
        catch (Exception e) {
            LOG.error("Error during initializing Recon server.", (Throwable)e);
        }
        this.start();
        this.isStarted = true;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.stop();
                this.join();
            }
            catch (Exception e) {
                LOG.error("Error during stop Recon server", (Throwable)e);
            }
        }));
        return null;
    }

    public void start() throws Exception {
        if (!this.isStarted) {
            LOG.info("Starting Recon server");
            this.isStarted = true;
            HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"Recon");
            if (this.httpServer != null) {
                this.httpServer.start();
            }
            if (this.ozoneManagerServiceProvider != null) {
                this.ozoneManagerServiceProvider.start();
            }
            if (this.reconStorageContainerManager != null) {
                this.reconStorageContainerManager.start();
            }
        }
    }

    public void stop() throws Exception {
        if (this.isStarted) {
            LOG.info("Stopping Recon server");
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
            if (this.reconStorageContainerManager != null) {
                this.reconStorageContainerManager.stop();
            }
            if (this.ozoneManagerServiceProvider != null) {
                this.ozoneManagerServiceProvider.stop();
            }
            if (this.containerDBServiceProvider != null) {
                this.containerDBServiceProvider.close();
            }
            this.isStarted = false;
        }
    }

    public void join() {
        if (this.reconStorageContainerManager != null) {
            this.reconStorageContainerManager.join();
        }
    }

    private static void loginReconUserIfSecurityEnabled(OzoneConfiguration conf) {
        try {
            if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
                ReconServer.loginReconUser(conf);
            }
        }
        catch (Exception ex) {
            LOG.error("Error login in as Recon service. ", (Throwable)ex);
        }
    }

    private static void loginReconUser(OzoneConfiguration conf) throws IOException, AuthenticationException {
        if (!SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
            throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)conf) + " authentication method not supported. Recon service login failed.");
        }
        ReconConfig reconConfig = (ReconConfig)conf.getObject(ReconConfig.class);
        LOG.info("Ozone security is enabled. Attempting login for Recon service. Principal: {}, keytab: {}", (Object)reconConfig.getKerberosPrincipal(), (Object)reconConfig.getKerberosKeytab());
        UserGroupInformation.setConfiguration((Configuration)conf);
        InetSocketAddress socAddr = HddsUtils.getReconAddresses((ConfigurationSource)conf);
        SecurityUtil.login((Configuration)conf, (String)"ozone.recon.kerberos.keytab.file", (String)"ozone.recon.kerberos.principal", (String)socAddr.getHostName());
        LOG.info("Recon login successful.");
    }

    @VisibleForTesting
    public OzoneManagerServiceProvider getOzoneManagerServiceProvider() {
        return this.ozoneManagerServiceProvider;
    }

    @VisibleForTesting
    public OzoneStorageContainerManager getReconStorageContainerManager() {
        return this.reconStorageContainerManager;
    }

    @VisibleForTesting
    public StorageContainerServiceProvider getStorageContainerServiceProvider() {
        return (StorageContainerServiceProvider)this.injector.getInstance(StorageContainerServiceProvider.class);
    }

    @VisibleForTesting
    public ContainerDBServiceProvider getContainerDBServiceProvider() {
        return this.containerDBServiceProvider;
    }

    @VisibleForTesting
    ReconHttpServer getHttpServer() {
        return this.httpServer;
    }
}

