/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.inject.Scopes;
import com.google.inject.servlet.ServletModule;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.ozone.recon.GuiceResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReconRestServletModule
extends ServletModule {
    private static final Logger LOG = LoggerFactory.getLogger(ReconRestServletModule.class);

    protected abstract void configureServlets();

    protected RestKeyBindingBuilder rest(String ... urlPatterns) {
        return new RestKeyBindingBuilderImpl(Arrays.asList(urlPatterns));
    }

    private class RestKeyBindingBuilderImpl
    implements RestKeyBindingBuilder {
        private List<String> paths;

        RestKeyBindingBuilderImpl(List<String> paths) {
            this.paths = paths;
        }

        private void checkIfPackageExistsAndLog(String pkg) {
            String resourcePath = pkg.replace(".", "/");
            URL resource = this.getClass().getClassLoader().getResource(resourcePath);
            if (resource != null) {
                LOG.info("rest({}).packages({})", this.paths, (Object)pkg);
            } else {
                LOG.info("No Beans in '{}' found. Requests {} will fail.", (Object)pkg, this.paths);
            }
        }

        @Override
        public void packages(String ... packages) {
            StringBuilder sb = new StringBuilder();
            for (String pkg : packages) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                this.checkIfPackageExistsAndLog(pkg);
                sb.append(pkg);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("javax.ws.rs.Application", GuiceResourceConfig.class.getCanonicalName());
            if (sb.length() > 0) {
                params.put("jersey.config.server.provider.packages", sb.toString());
            }
            ReconRestServletModule.this.bind(ServletContainer.class).in(Scopes.SINGLETON);
            for (String path : this.paths) {
                ReconRestServletModule.this.serve(path, new String[0]).with(ServletContainer.class, params);
            }
        }
    }

    public static interface RestKeyBindingBuilder {
        public void packages(String ... var1);
    }
}

