/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.prefix;

import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import picocli.CommandLine;

public class PrefixUri
implements CommandLine.ITypeConverter<OzoneAddress> {
    private static final String OZONE_PREFIX_URI_DESCRIPTION = "URI of the volume/bucket/prefix.\nOzone URI could start with o3:// or without prefix. URI may contain the host/serviceId and port of the OM server. Both are optional. If they are not specified it will be identified from the config files.";
    @CommandLine.Parameters(index="0", arity="1..1", description={"URI of the volume/bucket/prefix.\nOzone URI could start with o3:// or without prefix. URI may contain the host/serviceId and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."}, converter={PrefixUri.class})
    private OzoneAddress value;

    public OzoneAddress getValue() {
        return this.value;
    }

    public OzoneAddress convert(String str) throws OzoneClientException {
        OzoneAddress address = new OzoneAddress(str);
        address.ensurePrefixAddress();
        return address;
    }
}

