/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Gets a specific key from ozone server"})
public class GetKeyHandler
extends KeyHandler {
    @CommandLine.Parameters(index="1", arity="1..1", description={"File path to download the key to"})
    private String fileName;
    @CommandLine.Option(names={"-f", "--force"}, description={"Overwrite local file if it exists"}, defaultValue="false")
    private boolean force;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        String keyName = address.getKeyName();
        File dataFile = new File(this.fileName);
        if (dataFile.exists() && dataFile.isDirectory()) {
            dataFile = new File(this.fileName, keyName);
        }
        if (dataFile.exists() && !this.force) {
            throw new OzoneClientException(dataFile.getPath() + " exists. Download would overwrite an existing file. Aborting.");
        }
        int chunkSize = (int)this.getConf().getStorageSize("ozone.scm.chunk.size", "4MB", StorageUnit.BYTES);
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        try (OzoneInputStream input = bucket.readKey(keyName);
             FileOutputStream output = new FileOutputStream(dataFile);){
            IOUtils.copyBytes((InputStream)input, (OutputStream)output, (int)chunkSize);
        }
        if (this.isVerbose() && !"/dev/null".equals(dataFile.getAbsolutePath())) {
            var11_11 = null;
            try (FileInputStream stream = new FileInputStream(dataFile);){
                String hash = DigestUtils.md5Hex((InputStream)stream);
                this.out().printf("Downloaded file hash : %s%n", hash);
            }
            catch (Throwable throwable) {
                var11_11 = throwable;
                throw throwable;
            }
        }
    }
}

