/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.SetSpaceQuotaOptions;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="setquota", description={"Set quota of the buckets"})
public class SetQuotaHandler
extends BucketHandler {
    @CommandLine.Mixin
    private SetSpaceQuotaOptions quotaOptions;

    @Override
    public void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneBucket bucket = client.getObjectStore().getVolume(volumeName).getBucket(bucketName);
        long spaceQuota = bucket.getQuotaInBytes();
        long namespaceQuota = bucket.getQuotaInNamespace();
        if (!Strings.isNullOrEmpty((String)this.quotaOptions.getQuotaInBytes())) {
            spaceQuota = OzoneQuota.parseSpaceQuota((String)this.quotaOptions.getQuotaInBytes()).getQuotaInBytes();
        }
        if (!Strings.isNullOrEmpty((String)this.quotaOptions.getQuotaInNamespace())) {
            namespaceQuota = OzoneQuota.parseNameSpaceQuota((String)this.quotaOptions.getQuotaInNamespace()).getQuotaInNamespace();
        }
        if (bucket.getQuotaInNamespace() == -2L || bucket.getUsedBytes() == -2L) {
            String msg = "Bucket " + bucketName + " is created before version 1.1.0, usedBytes or usedNamespace may be inaccurate and it is not recommended to enable quota.";
            this.printMsg(msg);
        }
        bucket.setQuota(OzoneQuota.getOzoneQuota((long)spaceQuota, (long)namespaceQuota));
    }
}

