/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.ListOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.volume.VolumeHandler;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"lists the buckets in a volume."})
public class ListBucketHandler
extends VolumeHandler {
    @CommandLine.Mixin
    private ListOptions listOptions;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        int counter;
        String volumeName = address.getVolumeName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        Iterator bucketIterator = vol.listBuckets(this.listOptions.getPrefix(), this.listOptions.getStartItem());
        for (counter = 0; this.listOptions.getLimit() > counter && bucketIterator.hasNext(); ++counter) {
            this.printObjectAsJson(bucketIterator.next());
        }
        if (this.isVerbose()) {
            this.out().printf("Found : %d buckets for volume : %s ", counter, volumeName);
        }
    }
}

