/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.http.client.utils.URIBuilder;

public class OzoneAddress {
    private static final int DEFAULT_OZONE_PORT = 50070;
    private static final String EMPTY_HOST = "___DEFAULT___";
    private URI ozoneURI;
    private String volumeName = "";
    private String bucketName = "";
    private String keyName = "";
    private boolean isPrefix = false;

    public OzoneAddress() throws OzoneClientException {
        this("o3:///");
    }

    public OzoneAddress(String address) throws OzoneClientException {
        if (address == null || address.equals("")) {
            address = "o3:///";
        }
        this.ozoneURI = this.parseURI(address);
        String path = this.ozoneURI.getPath();
        path = path.replaceAll("^/+", "");
        int sep1 = path.indexOf(47);
        int sep2 = path.indexOf(47, sep1 + 1);
        if (sep1 == -1) {
            this.volumeName = path;
        } else {
            this.volumeName = path.substring(0, sep1);
            if (sep2 == -1) {
                this.bucketName = path.substring(sep1 + 1);
            } else {
                this.bucketName = path.substring(sep1 + 1, sep2);
                this.keyName = path.substring(sep2 + 1);
            }
        }
    }

    @VisibleForTesting
    protected OzoneClient createRpcClient(ConfigurationSource conf) throws IOException {
        return OzoneClientFactory.getRpcClient((ConfigurationSource)conf);
    }

    @VisibleForTesting
    protected OzoneClient createRpcClientFromHostPort(String host, int port, MutableConfigurationSource conf) throws IOException {
        return OzoneClientFactory.getRpcClient((String)this.ozoneURI.getHost(), (Integer)port, (MutableConfigurationSource)conf);
    }

    @VisibleForTesting
    protected OzoneClient createRpcClientFromServiceId(String serviceId, MutableConfigurationSource conf) throws IOException {
        return OzoneClientFactory.getRpcClient((String)serviceId, (ConfigurationSource)conf);
    }

    public OzoneClient createClient(MutableConfigurationSource conf) throws IOException, OzoneClientException {
        OzoneClient client;
        String scheme = this.ozoneURI.getScheme();
        if (this.ozoneURI.getScheme() == null || scheme.isEmpty()) {
            scheme = "o3";
        }
        if (scheme.equals("http")) {
            throw new UnsupportedOperationException("REST schema is not supported any more. Please use AWS S3 protocol if you need REST interface.");
        }
        if (!scheme.equals("o3")) {
            throw new OzoneClientException("Invalid URI, unknown protocol scheme: " + scheme + ". Use " + "o3" + ":// as the scheme");
        }
        if (this.ozoneURI.getHost() != null && !this.ozoneURI.getAuthority().equals(EMPTY_HOST)) {
            if (OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)this.ozoneURI.getHost())) {
                if (this.ozoneURI.getPort() != -1) {
                    throw new OzoneClientException("Port " + this.ozoneURI.getPort() + " specified in URI but host '" + this.ozoneURI.getHost() + "' is a logical (HA) OzoneManager and does not use port information.");
                }
                client = this.createRpcClient((ConfigurationSource)conf);
            } else {
                client = this.ozoneURI.getPort() == -1 ? this.createRpcClientFromHostPort(this.ozoneURI.getHost(), OmUtils.getOmRpcPort((ConfigurationSource)conf), conf) : this.createRpcClientFromHostPort(this.ozoneURI.getHost(), this.ozoneURI.getPort(), conf);
            }
        } else {
            Collection omServiceIds = conf.getTrimmedStringCollection("ozone.om.service.ids");
            if (omServiceIds.size() > 1) {
                throw new OzoneClientException("Service ID or host name must not be omitted when multiple ozone.om.service.ids is defined.");
            }
            client = omServiceIds.size() == 1 ? this.createRpcClientFromServiceId((String)omServiceIds.iterator().next(), conf) : this.createRpcClient((ConfigurationSource)conf);
        }
        return client;
    }

    public OzoneClient createClientForS3Commands(OzoneConfiguration conf, String omServiceID) throws IOException, OzoneClientException {
        if (omServiceID != null) {
            if (OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omServiceID)) {
                return OzoneClientFactory.getRpcClient((String)omServiceID, (ConfigurationSource)conf);
            }
            throw new OzoneClientException("Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are" + conf.getTrimmedStringCollection("ozone.om.service.ids"));
        }
        if (OmUtils.isServiceIdsDefined((ConfigurationSource)conf)) {
            throw new OzoneClientException("Service ID must not be omitted when ozone.om.service.ids is defined. Configured ozone.om.service.ids are " + conf.getTrimmedStringCollection("ozone.om.service.ids"));
        }
        return OzoneClientFactory.getRpcClient((ConfigurationSource)conf);
    }

    protected URI parseURI(String uri) throws OzoneClientException {
        if (uri == null || uri.isEmpty()) {
            throw new OzoneClientException("Ozone URI is needed to execute this command.");
        }
        URIBuilder uriBuilder = new URIBuilder(OzoneAddress.stringToUri(uri));
        if (uriBuilder.getPort() == 0) {
            uriBuilder.setPort(50070);
        }
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new OzoneClientException("Invalid URI: " + this.ozoneURI, (Throwable)e);
        }
    }

    private static URI stringToUri(String pathString) {
        String path;
        int firstSlash;
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon > 0 && slash == colon + 1) {
            scheme = pathString.substring(0, colon);
            start = colon + 1;
        }
        if (pathString.startsWith("//", start) && pathString.length() - start > 2) {
            int nextSlash = pathString.indexOf(47, start += 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start, authEnd);
            start = authEnd;
        }
        if ((firstSlash = (path = pathString.substring(start, pathString.length())).indexOf(47)) != 0) {
            path = "/" + path;
        }
        if (authority == null || authority.equals("")) {
            authority = EMPTY_HOST;
        }
        try {
            return new URI(scheme, authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public void ensureBucketAddress() throws OzoneClientException {
        if (this.keyName.length() > 0) {
            throw new OzoneClientException("Invalid bucket name. Delimiters (/) not allowed in bucket name");
        }
        if (this.volumeName.length() == 0) {
            throw new OzoneClientException("Volume name is required.");
        }
        if (this.bucketName.length() == 0) {
            throw new OzoneClientException("Bucket name is required.");
        }
    }

    public void ensurePrefixAddress() throws OzoneClientException {
        if (this.keyName.length() == 0) {
            throw new OzoneClientException("prefix name is missing.");
        }
        if (this.volumeName.length() == 0) {
            throw new OzoneClientException("Volume name is missing");
        }
        if (this.bucketName.length() == 0) {
            throw new OzoneClientException("Bucket name is missing");
        }
        this.isPrefix = true;
    }

    public void ensureKeyAddress() throws OzoneClientException {
        if (this.keyName.length() == 0) {
            throw new OzoneClientException("Key name is missing.");
        }
        if (this.volumeName.length() == 0) {
            throw new OzoneClientException("Volume name is missing");
        }
        if (this.bucketName.length() == 0) {
            throw new OzoneClientException("Bucket name is missing");
        }
    }

    public void ensureVolumeAddress() throws OzoneClientException {
        if (this.keyName.length() != 0) {
            throw new OzoneClientException("Invalid volume name. Delimiters (/) not allowed in volume name");
        }
        if (this.volumeName.length() == 0) {
            throw new OzoneClientException("Volume name is required");
        }
        if (this.bucketName.length() != 0) {
            throw new OzoneClientException("Invalid volume name. Delimiters (/) not allowed in volume name");
        }
    }

    public void ensureRootAddress() throws OzoneClientException {
        if (this.keyName.length() != 0 || this.bucketName.length() != 0 || this.volumeName.length() != 0) {
            throw new OzoneClientException("Invalid URI. Volume/bucket/key elements should not been used");
        }
    }

    public OzoneObj toOzoneObj(OzoneObj.StoreType storeType) {
        return OzoneObjInfo.Builder.newBuilder().setBucketName(this.bucketName).setVolumeName(this.volumeName).setKeyName(this.keyName).setResType(this.getResourceType()).setStoreType(storeType).build();
    }

    private OzoneObj.ResourceType getResourceType() {
        if (!this.keyName.isEmpty()) {
            return this.isPrefix ? OzoneObj.ResourceType.PREFIX : OzoneObj.ResourceType.KEY;
        }
        if (!this.bucketName.isEmpty()) {
            return OzoneObj.ResourceType.BUCKET;
        }
        if (!this.volumeName.isEmpty()) {
            return OzoneObj.ResourceType.VOLUME;
        }
        return null;
    }

    public void print(PrintStream out) {
        if (!this.volumeName.isEmpty()) {
            out.printf("Volume Name : %s%n", this.volumeName);
        }
        if (!this.bucketName.isEmpty()) {
            out.printf("Bucket Name : %s%n", this.bucketName);
        }
        if (!this.keyName.isEmpty()) {
            out.printf("Key Name : %s%n", this.keyName);
        }
    }
}

