/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressBar {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressBar.class);
    private final long maxValue;
    private final LongSupplier currentValue;
    private final Thread thread;
    private volatile boolean running;
    private volatile long startTime;
    private boolean interactive;

    public ProgressBar(PrintStream stream, long maxValue, LongSupplier currentValue) {
        this(stream, maxValue, currentValue, System.console() != null);
    }

    public ProgressBar(PrintStream stream, long maxValue, LongSupplier currentValue, boolean interactive) {
        this.maxValue = maxValue;
        this.currentValue = currentValue;
        this.thread = new Thread(this.getProgressBar(stream));
        this.interactive = interactive;
    }

    public synchronized void start() {
        if (!this.running) {
            this.running = true;
            this.startTime = System.nanoTime();
            this.thread.start();
        }
    }

    public synchronized void shutdown() {
        if (this.running) {
            try {
                this.thread.join();
                this.running = false;
            }
            catch (InterruptedException e) {
                LOG.warn("Got interrupted while waiting for the progress bar to complete.");
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void terminate() {
        if (this.running) {
            try {
                this.running = false;
                this.thread.join();
            }
            catch (InterruptedException e) {
                LOG.warn("Got interrupted while waiting for the progress bar to complete.");
                Thread.currentThread().interrupt();
            }
        }
    }

    private Runnable getProgressBar(PrintStream stream) {
        return () -> {
            this.println(stream);
            while (this.running && this.currentValue.getAsLong() < this.maxValue) {
                this.print(stream, this.currentValue.getAsLong());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.warn("ProgressBar was interrupted.");
                    Thread.currentThread().interrupt();
                }
            }
            this.print(stream, this.maxValue);
            this.println(stream);
            this.running = false;
        };
    }

    public void print(PrintStream stream, long value) {
        if (this.interactive) {
            this.printProgressBar(stream, value);
        } else {
            this.logProgressBar(stream, value);
        }
    }

    private void println(PrintStream stream) {
        if (this.interactive) {
            stream.println();
        }
    }

    private void logProgressBar(PrintStream stream, long value) {
        double percent = 100.0 * (double)value / (double)this.maxValue;
        LOG.info(String.format("Progress: %.2f %% (%d out of %d)", percent, value, this.maxValue));
    }

    private void printProgressBar(PrintStream stream, long value) {
        stream.print('\r');
        double percent = 100.0 * (double)value / (double)this.maxValue;
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(String.format("%.2f", percent)).append("% |");
        int i = 0;
        while ((double)i <= percent) {
            sb.append('\u2588');
            ++i;
        }
        int j = 0;
        while ((double)j < 100.0 - percent) {
            sb.append(' ');
            ++j;
        }
        sb.append("|  ");
        sb.append(value).append("/").append(this.maxValue);
        long timeInSec = TimeUnit.SECONDS.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
        String timeToPrint = String.format("%d:%02d:%02d", timeInSec / 3600L, timeInSec % 3600L / 60L, timeInSec % 60L);
        sb.append(" Time: ").append(timeToPrint);
        stream.print(sb.toString());
    }
}

