/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.ozone.debug.RDBParser;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import picocli.CommandLine;

@CommandLine.Command(name="drop_column_family", description={"drop column family in db."})
public class DropTable
implements Callable<Void>,
SubcommandWithParent {
    @CommandLine.Option(names={"--column_family"}, description={"Table name"})
    private String tableName;
    @CommandLine.ParentCommand
    private RDBParser parent;

    @Override
    public Void call() throws Exception {
        List<ColumnFamilyDescriptor> cfs = RocksDBUtils.getColumnFamilyDescriptors(this.parent.getDbPath());
        ArrayList columnFamilyHandleList = new ArrayList();
        try (RocksDB rocksDB = RocksDB.open((String)this.parent.getDbPath(), cfs, columnFamilyHandleList);){
            byte[] nameBytes = this.tableName.getBytes(StandardCharsets.UTF_8);
            ColumnFamilyHandle toBeDeletedCf = null;
            for (ColumnFamilyHandle cf : columnFamilyHandleList) {
                if (!Arrays.equals(cf.getName(), nameBytes)) continue;
                toBeDeletedCf = cf;
                break;
            }
            if (toBeDeletedCf == null) {
                System.err.println(this.tableName + " is not in a column family in DB " + this.parent.getDbPath());
            } else {
                System.out.println(this.tableName + " will be deleted from DB " + this.parent.getDbPath());
                rocksDB.dropColumnFamily(toBeDeletedCf);
            }
        }
        return null;
    }

    public Class<?> getParentType() {
        return RDBParser.class;
    }
}

