/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.conf;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.conf.OzoneGetConf;
import picocli.CommandLine;

@CommandLine.Command(name="ozonemanagers", aliases={"-ozonemanagers"}, description={"gets list of ozone storage container manager nodes in the cluster"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class OzoneManagersCommandHandler
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OzoneGetConf tool;

    @Override
    public Void call() throws Exception {
        OzoneConfiguration configSource = OzoneConfiguration.of((OzoneConfiguration)this.tool.getConf());
        if (OmUtils.isServiceIdsDefined((ConfigurationSource)configSource)) {
            this.tool.printOut(OmUtils.getOmHAAddressesById((ConfigurationSource)configSource).toString());
        } else {
            this.tool.printOut(OmUtils.getOmAddress((ConfigurationSource)configSource).getHostName());
        }
        return null;
    }
}

