/*
 * Decompiled with CFR 0.152.
 */
package org.hadoop.ozone.recon.schema;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hadoop.ozone.recon.codegen.SqlDbUtils;
import org.hadoop.ozone.recon.schema.ReconSchemaDefinition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Name;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

@Singleton
public class ContainerSchemaDefinition
implements ReconSchemaDefinition {
    public static final String UNHEALTHY_CONTAINERS_TABLE_NAME = "UNHEALTHY_CONTAINERS";
    private static final String CONTAINER_ID = "container_id";
    private static final String CONTAINER_STATE = "container_state";
    private final DataSource dataSource;
    private DSLContext dslContext;

    @Inject
    ContainerSchemaDefinition(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void initializeSchema() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        this.dslContext = DSL.using((Connection)conn);
        if (!SqlDbUtils.TABLE_EXISTS_CHECK.test(conn, UNHEALTHY_CONTAINERS_TABLE_NAME)) {
            this.createUnhealthyContainersTable();
        }
    }

    private void createUnhealthyContainersTable() {
        this.dslContext.createTableIfNotExists(UNHEALTHY_CONTAINERS_TABLE_NAME).column(CONTAINER_ID, SQLDataType.BIGINT.nullable(false)).column(CONTAINER_STATE, SQLDataType.VARCHAR((int)16).nullable(false)).column("in_state_since", SQLDataType.BIGINT.nullable(false)).column("expected_replica_count", SQLDataType.INTEGER.nullable(false)).column("actual_replica_count", SQLDataType.INTEGER.nullable(false)).column("replica_delta", SQLDataType.INTEGER.nullable(false)).column("reason", SQLDataType.VARCHAR((int)500).nullable(true)).constraint((Constraint)DSL.constraint((String)"pk_container_id").primaryKey(new String[]{CONTAINER_ID, CONTAINER_STATE})).constraint((Constraint)DSL.constraint((String)"UNHEALTHY_CONTAINERSck1").check(DSL.field((Name)DSL.name((String)CONTAINER_STATE)).in((Object[])UnHealthyContainerStates.values()))).execute();
    }

    public DSLContext getDSLContext() {
        return this.dslContext;
    }

    public static enum UnHealthyContainerStates {
        MISSING,
        UNDER_REPLICATED,
        OVER_REPLICATED,
        MIS_REPLICATED;

    }
}

