/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.el.ELContextListener;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.helpers.EEModuleDescriptorImpl;
import org.jboss.weld.bootstrap.spi.helpers.MetadataImpl;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.configuration.spi.helpers.ExternalConfigurationBuilder;
import org.jboss.weld.el.WeldELContextListener;
import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.ContainerInstance;
import org.jboss.weld.environment.ContainerInstanceFactory;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.WeldDeployment;
import org.jboss.weld.environment.deployment.WeldResourceLoader;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategyFactory;
import org.jboss.weld.environment.deployment.discovery.jandex.Jandex;
import org.jboss.weld.environment.gwtdev.GwtDevHostedModeContainer;
import org.jboss.weld.environment.jetty.JettyContainer;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.environment.servlet.SecurityActions;
import org.jboss.weld.environment.servlet.deployment.ServletContextBeanArchiveHandler;
import org.jboss.weld.environment.servlet.deployment.WebAppBeanArchiveScanner;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.environment.servlet.services.ServletResourceInjectionServices;
import org.jboss.weld.environment.tomcat.TomcatContainer;
import org.jboss.weld.environment.undertow.UndertowContainer;
import org.jboss.weld.environment.util.DevelopmentMode;
import org.jboss.weld.environment.util.Reflections;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.resources.ManagerObjectFactory;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.servlet.WeldInitialListener;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.util.collections.ImmutableSet;

public class WeldServletLifecycle {
    public static final String BEAN_MANAGER_ATTRIBUTE_NAME = WeldServletLifecycle.class.getPackage().getName() + "." + BeanManager.class.getName();
    static final String INSTANCE_ATTRIBUTE_NAME = WeldServletLifecycle.class.getPackage().getName() + ".lifecycleInstance";
    private static final String EXPRESSION_FACTORY_NAME = "org.jboss.weld.el.ExpressionFactory";
    private static final String CONTEXT_PARAM_ARCHIVE_ISOLATION = WeldServletLifecycle.class.getPackage().getName() + ".archive.isolation";
    private static final String JANDEX_SERVLET_CONTEXT_BEAN_ARCHIVE_HANDLER = "org.jboss.weld.environment.servlet.deployment.JandexServletContextBeanArchiveHandler";
    private static final String CONTEXT_PARAM_DEV_MODE = "org.jboss.weld.development";
    private static final String JSP_FACTORY_CLASS_NAME = "javax.servlet.jsp.JspFactory";
    private Runnable shutdownAction;
    private final transient ServletListener weldListener;
    private final transient ResourceLoader resourceLoader = new WeldResourceLoader();
    private Container container;
    private boolean isBootstrapNeeded = true;
    private boolean isDevModeEnabled;

    WeldServletLifecycle() {
        this.weldListener = new WeldInitialListener();
    }

    boolean initialize(ServletContext context) {
        StringBuilder dump;
        ContainerContext containerContext;
        Container container;
        this.isDevModeEnabled = Boolean.valueOf(context.getInitParameter(CONTEXT_PARAM_DEV_MODE));
        WeldManager manager = (WeldManager)context.getAttribute(BEAN_MANAGER_ATTRIBUTE_NAME);
        if (manager != null) {
            this.isBootstrapNeeded = false;
            String contextId = BeanManagerProxy.unwrap(manager).getContextId();
            context.setInitParameter("WELD_CONTEXT_ID_KEY", contextId);
        } else {
            Object container2 = context.getAttribute(Listener.CONTAINER_ATTRIBUTE_NAME);
            if (container2 instanceof ContainerInstanceFactory) {
                ContainerInstanceFactory factory = (ContainerInstanceFactory)container2;
                final ContainerInstance containerInstance = factory.initialize();
                container2 = containerInstance;
                this.shutdownAction = new Runnable(){

                    @Override
                    public void run() {
                        containerInstance.shutdown();
                    }
                };
            }
            if (container2 instanceof ContainerInstance) {
                ContainerInstance containerInstance = (ContainerInstance)container2;
                manager = BeanManagerProxy.unwrap(containerInstance.getBeanManager());
                context.setInitParameter("WELD_CONTEXT_ID_KEY", containerInstance.getId());
                this.isBootstrapNeeded = false;
            }
        }
        final WeldBootstrap bootstrap = new WeldBootstrap();
        if (this.isBootstrapNeeded) {
            CDI11Deployment deployment = this.createDeployment(context, bootstrap);
            deployment.getServices().add(ExternalConfiguration.class, new ExternalConfigurationBuilder().add(ConfigurationKey.BEAN_IDENTIFIER_INDEX_OPTIMIZATION.get(), Boolean.FALSE.toString()).build());
            if (deployment.getBeanDeploymentArchives().isEmpty()) {
                CommonLogger.LOG.initSkippedNoBeanArchiveFound();
                return false;
            }
            ServletResourceInjectionServices resourceInjectionServices = new ServletResourceInjectionServices(){};
            try {
                for (BeanDeploymentArchive beanDeploymentArchive : deployment.getBeanDeploymentArchives()) {
                    beanDeploymentArchive.getServices().add(ResourceInjectionServices.class, resourceInjectionServices);
                }
            }
            catch (NoClassDefFoundError e) {
                WeldServletLogger.LOG.resourceInjectionNotAvailable();
            }
            String id = context.getInitParameter("WELD_CONTEXT_ID_KEY");
            if (id != null) {
                bootstrap.startContainer(id, Environments.SERVLET, deployment);
            } else {
                bootstrap.startContainer(Environments.SERVLET, deployment);
            }
            bootstrap.startInitialization();
            for (BeanDeploymentArchive bda : deployment.getBeanDeploymentArchives()) {
                if (!bda.getId().contains(ManagerObjectFactory.WEB_INF_CLASSES_FILE_PATH) && !bda.getId().contains("/WEB-INF/classes")) continue;
                manager = bootstrap.getManager(bda);
                break;
            }
            if (manager == null) {
                manager = bootstrap.getManager(deployment.getBeanDeploymentArchives().iterator().next());
            }
            context.setAttribute(BEAN_MANAGER_ATTRIBUTE_NAME, (Object)manager);
        }
        if ((container = this.findContainer(containerContext = new ContainerContext(context, manager), dump = new StringBuilder())) == null) {
            WeldServletLogger.LOG.noSupportedServletContainerDetected();
            WeldServletLogger.LOG.debugv("Exception dump from Container lookup: {0}", (Object)dump);
        } else {
            container.initialize(containerContext);
            this.container = container;
        }
        if (Reflections.isClassLoadable(WeldClassLoaderResourceLoader.INSTANCE, JSP_FACTORY_CLASS_NAME) && JspFactory.getDefaultFactory() != null) {
            JspApplicationContext jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(context);
            jspApplicationContext.addELResolver(manager.getELResolver());
            try {
                jspApplicationContext.addELContextListener((ELContextListener)new WeldELContextListener());
            }
            catch (Exception e) {
                throw WeldServletLogger.LOG.errorLoadingWeldELContextListener(e);
            }
            context.setAttribute(EXPRESSION_FACTORY_NAME, (Object)manager.wrapExpressionFactory(jspApplicationContext.getExpressionFactory()));
        }
        if (this.isBootstrapNeeded) {
            bootstrap.deployBeans().validateBeans().endInitialization();
            if (this.isDevModeEnabled) {
                FilterRegistration.Dynamic dynamic = context.addFilter("Weld Probe Filter", "org.jboss.weld.probe.ProbeFilter");
                dynamic.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE), true, new String[]{"/*"});
            }
            this.shutdownAction = new Runnable(){

                @Override
                public void run() {
                    bootstrap.shutdown();
                }
            };
        }
        return true;
    }

    void destroy(ServletContext context) {
        if (this.shutdownAction != null) {
            this.shutdownAction.run();
        }
        if (this.container != null) {
            this.container.destroy(new ContainerContext(context, null));
        }
    }

    ServletListener getWeldListener() {
        return this.weldListener;
    }

    protected CDI11Deployment createDeployment(ServletContext context, CDI11Bootstrap bootstrap) {
        Object flatDeployment;
        ImmutableSet.Builder<Metadata<Extension>> extensionsBuilder = ImmutableSet.builder();
        extensionsBuilder.addAll(bootstrap.loadExtensions(WeldResourceLoader.getClassLoader()));
        if (this.isDevModeEnabled) {
            extensionsBuilder.add(new MetadataImpl<Extension>(DevelopmentMode.getProbeExtension(this.resourceLoader), "N/A"));
        }
        Set<Metadata<Extension>> extensions = extensionsBuilder.build();
        TypeDiscoveryConfiguration typeDiscoveryConfiguration = bootstrap.startExtensions(extensions);
        final EEModuleDescriptorImpl eeModule = new EEModuleDescriptorImpl(context.getContextPath(), EEModuleDescriptor.ModuleType.WEB);
        DiscoveryStrategy strategy = DiscoveryStrategyFactory.create(this.resourceLoader, bootstrap, typeDiscoveryConfiguration.getKnownBeanDefiningAnnotations(), Boolean.parseBoolean(context.getInitParameter("org.jboss.weld.discovery.disableJandexDiscovery")));
        if (Jandex.isJandexAvailable(this.resourceLoader)) {
            try {
                Class handlerClass = Reflections.loadClass(this.resourceLoader, JANDEX_SERVLET_CONTEXT_BEAN_ARCHIVE_HANDLER);
                strategy.registerHandler((BeanArchiveHandler)SecurityActions.newConstructorInstance(handlerClass, new Class[]{ServletContext.class}, context));
            }
            catch (Exception e) {
                throw CommonLogger.LOG.unableToInstantiate(JANDEX_SERVLET_CONTEXT_BEAN_ARCHIVE_HANDLER, Arrays.toString(new Object[]{context}), e);
            }
        } else {
            strategy.registerHandler(new ServletContextBeanArchiveHandler(context));
        }
        strategy.setScanner(new WebAppBeanArchiveScanner(this.resourceLoader, bootstrap, context));
        Object beanDeploymentArchives = strategy.performDiscovery();
        String isolation = context.getInitParameter(CONTEXT_PARAM_ARCHIVE_ISOLATION);
        if (isolation == null || Boolean.valueOf(isolation).booleanValue()) {
            CommonLogger.LOG.archiveIsolationEnabled();
        } else {
            CommonLogger.LOG.archiveIsolationDisabled();
            flatDeployment = new HashSet();
            flatDeployment.add(WeldBeanDeploymentArchive.merge(bootstrap, beanDeploymentArchives));
            beanDeploymentArchives = flatDeployment;
        }
        flatDeployment = beanDeploymentArchives.iterator();
        while (flatDeployment.hasNext()) {
            BeanDeploymentArchive archive = (BeanDeploymentArchive)flatDeployment.next();
            archive.getServices().add(EEModuleDescriptor.class, eeModule);
        }
        WeldDeployment deployment = new WeldDeployment(this.resourceLoader, bootstrap, (Set)beanDeploymentArchives, extensions){

            @Override
            protected WeldBeanDeploymentArchive createAdditionalBeanDeploymentArchive() {
                WeldBeanDeploymentArchive archive = super.createAdditionalBeanDeploymentArchive();
                archive.getServices().add(EEModuleDescriptor.class, eeModule);
                return archive;
            }
        };
        if (strategy.getClassFileServices() != null) {
            deployment.getServices().add(ClassFileServices.class, strategy.getClassFileServices());
        }
        return deployment;
    }

    protected Container findContainer(ContainerContext ctx, StringBuilder dump) {
        ServiceLoader<Container> extContainers;
        Container container = null;
        String containerClassName = ctx.getServletContext().getInitParameter(Container.CONTEXT_PARAM_CONTAINER_CLASS);
        if (containerClassName != null) {
            try {
                Class containerClass = Reflections.classForName(this.resourceLoader, containerClassName);
                container = (Container)SecurityActions.newInstance(containerClass);
                WeldServletLogger.LOG.containerDetectionSkipped(containerClassName);
            }
            catch (Exception e) {
                WeldServletLogger.LOG.unableToInstantiateCustomContainerClass(containerClassName);
                WeldServletLogger.LOG.catchingDebug(e);
            }
        }
        if (container == null && (container = this.checkContainers(ctx, dump, extContainers = ServiceLoader.load(Container.class, this.getClass().getClassLoader()))) == null) {
            container = this.checkContainers(ctx, dump, Arrays.asList(TomcatContainer.INSTANCE, JettyContainer.INSTANCE, UndertowContainer.INSTANCE, GwtDevHostedModeContainer.INSTANCE));
        }
        return container;
    }

    protected Container checkContainers(ContainerContext containerContext, StringBuilder dump, Iterable<Container> containers) {
        for (Container container : containers) {
            try {
                if (!container.touch(this.resourceLoader, containerContext)) continue;
                return container;
            }
            catch (Throwable t) {
                dump.append(container).append("->").append(t.getMessage()).append("\n");
            }
        }
        return null;
    }
}

