/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.interceptor.CdiInterceptorFactory;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.WeldInvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.proxy.WeldInvocationContextImpl;
import org.jboss.weld.interceptor.reader.InterceptorMetadataImpl;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Interceptors;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptorImpl<T>
extends ManagedBean<T>
implements Interceptor<T> {
    private final InterceptorClassMetadata<T> interceptorMetadata = this.initInterceptorMetadata();
    private final Set<Annotation> interceptorBindingTypes;
    private final boolean serializable;

    public static <T> InterceptorImpl<T> of(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        return new InterceptorImpl<T>(attributes, type, beanManager);
    }

    protected InterceptorImpl(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        super(attributes, type, new StringBeanIdentifier(BeanIdentifiers.forInterceptor(type)), beanManager);
        this.serializable = type.isSerializable();
        this.interceptorBindingTypes = Collections.unmodifiableSet(new HashSet<Annotation>(Interceptors.mergeBeanInterceptorBindings(beanManager, this.getEnhancedAnnotated(), this.getStereotypes()).values()));
        if (Beans.findInterceptorBindingConflicts(beanManager, this.interceptorBindingTypes)) {
            throw new DeploymentException(BeanLogger.LOG.conflictingInterceptorBindings(this.getType()));
        }
    }

    private InterceptorClassMetadata<T> initInterceptorMetadata() {
        CdiInterceptorFactory reference = new CdiInterceptorFactory(this);
        return new InterceptorMetadataImpl(this.getBeanClass(), reference, InterceptorMetadataUtils.buildMethodMap(this.getEnhancedAnnotated(), false, this.getBeanManager()));
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindingTypes;
    }

    public InterceptorClassMetadata<T> getInterceptorMetadata() {
        return this.interceptorMetadata;
    }

    @Override
    public Object intercept(javax.enterprise.inject.spi.InterceptionType type, T instance, InvocationContext ctx) {
        InterceptionType interceptionType = InterceptionType.valueOf(type.name());
        List<InterceptorMethodInvocation> methodInvocations = this.interceptorMetadata.getInterceptorInvocation(instance, interceptionType).getInterceptorMethodInvocations();
        Set<Annotation> interceptorBindings = null;
        if (ctx instanceof WeldInvocationContext) {
            interceptorBindings = ((WeldInvocationContext)Reflections.cast(ctx)).getInterceptorBindings();
        }
        try {
            return new WeldInvocationContextImpl(ctx, methodInvocations, interceptorBindings, null).proceed();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    @Override
    public boolean intercepts(javax.enterprise.inject.spi.InterceptionType type) {
        return this.interceptorMetadata.isEligible(InterceptionType.valueOf(type.name()));
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
        this.checkInterceptorBindings();
    }

    private void checkInterceptorBindings() {
        if (this.interceptorMetadata.isEligible(InterceptionType.POST_CONSTRUCT) || this.interceptorMetadata.isEligible(InterceptionType.PRE_DESTROY) || this.interceptorMetadata.isEligible(InterceptionType.POST_ACTIVATE) || this.interceptorMetadata.isEligible(InterceptionType.PRE_PASSIVATE)) {
            for (Annotation interceptorBindingType : this.interceptorBindingTypes) {
                Target target = interceptorBindingType.annotationType().getAnnotation(Target.class);
                if (target != null && !this.hasInvalidTargetType(target.value())) continue;
                ReflectionLogger.LOG.lifecycleCallbackInterceptorWithInvalidBindingTarget(this, interceptorBindingType.annotationType().getName(), target != null ? Arrays.toString((Object[])target.value()) : "Target meta-annotation is not present");
            }
        }
    }

    private boolean hasInvalidTargetType(ElementType[] elementTypes) {
        for (ElementType elementType : elementTypes) {
            if (ElementType.TYPE.equals((Object)elementType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "Interceptor [" + this.getBeanClass() + " intercepts " + Formats.formatAnnotations(this.getInterceptorBindings()) + "]";
    }
}

