/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmKeyInfoCodec
implements Codec<OmKeyInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(OmKeyInfoCodec.class);
    private final boolean ignorePipeline;

    public OmKeyInfoCodec(boolean ignorePipeline) {
        this.ignorePipeline = ignorePipeline;
        LOG.info("OmKeyInfoCodec ignorePipeline = {}", (Object)ignorePipeline);
    }

    public byte[] toPersistedFormat(OmKeyInfo object) throws IOException {
        Preconditions.checkNotNull((Object)object, (Object)"Null object can't be converted to byte array.");
        return object.getProtobuf(this.ignorePipeline, 1).toByteArray();
    }

    public OmKeyInfo fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull((Object)rawData, (Object)"Null byte array can't converted to real object.");
        try {
            return OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)OzoneManagerProtocolProtos.KeyInfo.parseFrom((byte[])rawData));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    public OmKeyInfo copyObject(OmKeyInfo omKeyInfo) {
        return omKeyInfo.copyObject();
    }
}

