/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.cache.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.nifi.minifi.c2.api.ConfigurationProviderException;
import org.apache.nifi.minifi.c2.api.cache.WriteableConfiguration;
import org.apache.nifi.minifi.c2.cache.s3.S3OutputStream;

public class S3WritableConfiguration
implements WriteableConfiguration {
    private final AmazonS3 s3;
    private final S3Object s3Object;
    private final String version;

    public S3WritableConfiguration(AmazonS3 s3, S3ObjectSummary s3ObjectSummary, String version) {
        this.s3 = s3;
        this.s3Object = s3.getObject(s3ObjectSummary.getBucketName(), s3ObjectSummary.getKey());
        this.version = version;
    }

    public S3WritableConfiguration(AmazonS3 s3, S3Object s3Object, String version) {
        this.s3 = s3;
        this.s3Object = s3Object;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean exists() {
        return this.s3.doesObjectExist(this.s3Object.getBucketName(), this.s3Object.getKey());
    }

    public OutputStream getOutputStream() throws ConfigurationProviderException {
        return new S3OutputStream(this.s3Object.getBucketName(), this.s3Object.getKey(), this.s3);
    }

    public InputStream getInputStream() throws ConfigurationProviderException {
        return this.s3Object.getObjectContent();
    }

    public URL getURL() throws ConfigurationProviderException {
        return this.s3.getUrl(this.s3Object.getBucketName(), this.s3Object.getKey());
    }

    public String getName() {
        return this.s3Object.getKey();
    }

    public String toString() {
        return "FileSystemWritableConfiguration{objectKey=" + this.s3Object.getKey() + ", version='" + this.version + "'}";
    }
}

