/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageAddressCacheRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Rows;

class AsyncFilteredRecordCursor
implements RecordCursor {
    private static final Log LOG = LogFactory.getLog(AsyncFilteredRecordCursor.class);
    private static final String exceptionMessage = "timeout, query aborted";
    private final Function filter;
    private final boolean hasDescendingOrder;
    private final PageAddressCacheRecord record;
    private boolean allFramesActive;
    private long cursor = -1L;
    private int frameIndex;
    private int frameLimit;
    private long frameRowCount;
    private long frameRowIndex;
    private PageFrameSequence<?> frameSequence;
    private boolean isOpen;
    private long ogRowsRemaining;
    private PageAddressCacheRecord recordB;
    private DirectLongList rows;
    private long rowsRemaining;

    public AsyncFilteredRecordCursor(Function filter, boolean hasDescendingOrder) {
        this.filter = filter;
        this.hasDescendingOrder = hasDescendingOrder;
        this.record = new PageAddressCacheRecord();
    }

    @Override
    public void close() {
        if (this.isOpen) {
            LOG.debug().$("closing [shard=").$(this.frameSequence.getShard()).$(", frameIndex=").$(this.frameIndex).$(", frameCount=").$(this.frameLimit).$(", frameId=").$(this.frameSequence.getId()).$(", cursor=").$(this.cursor).I$();
            if (this.frameSequence != null) {
                this.collectCursor(true);
                if (this.frameLimit > -1) {
                    this.frameSequence.await();
                }
                this.frameSequence.clear();
            }
            this.isOpen = false;
        }
    }

    public void freeRecords() {
        Misc.free(this.record);
        Misc.free(this.recordB);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record getRecordB() {
        if (this.recordB != null) {
            return this.recordB;
        }
        this.recordB = new PageAddressCacheRecord(this.record);
        return this.recordB;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (this.frameIndex == -1 && this.frameLimit > -1) {
            this.fetchNextFrame();
        }
        if (this.rowsRemaining < 0L) {
            return false;
        }
        if (this.frameRowIndex < this.frameRowCount) {
            this.record.setRowIndex(this.rows.get(this.rowIndex()));
            ++this.frameRowIndex;
            return this.checkLimit();
        }
        this.collectCursor(false);
        if (this.frameIndex < this.frameLimit) {
            this.fetchNextFrame();
            if (this.frameRowCount > 0L && this.frameRowIndex < this.frameRowCount) {
                this.record.setRowIndex(this.rows.get(this.rowIndex()));
                ++this.frameRowIndex;
                return this.checkLimit();
            }
        }
        if (!this.allFramesActive) {
            throw CairoException.nonCritical().put(exceptionMessage).setInterruption(true);
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().newSymbolTable(columnIndex);
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((PageAddressCacheRecord)record).setFrameIndex(Rows.toPartitionIndex(atRowId));
        ((PageAddressCacheRecord)record).setRowIndex(Rows.toLocalRowID(atRowId));
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        if (this.frameIndex == 0 && this.frameRowIndex == 0L) {
            return;
        }
        this.collectCursor(false);
        this.filter.toTop();
        this.frameSequence.toTop();
        this.rowsRemaining = this.ogRowsRemaining;
        if (this.frameLimit > -1) {
            this.frameIndex = -1;
        }
        this.allFramesActive = true;
    }

    private boolean checkLimit() {
        if (--this.rowsRemaining < 0L) {
            this.frameSequence.cancel();
            return false;
        }
        return true;
    }

    private void collectCursor(boolean forceCollect) {
        if (this.cursor > -1L) {
            this.frameSequence.collect(this.cursor, forceCollect);
            this.cursor = -1L;
        }
    }

    private void fetchNextFrame() {
        try {
            do {
                this.cursor = this.frameSequence.next();
                if (this.cursor > -1L) {
                    PageFrameReduceTask task = this.frameSequence.getTask(this.cursor);
                    LOG.debug().$("collected [shard=").$(this.frameSequence.getShard()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(this.frameSequence.getFrameCount()).$(", frameId=").$(this.frameSequence.getId()).$(", active=").$(this.frameSequence.isActive()).$(", cursor=").$(this.cursor).I$();
                    this.allFramesActive &= this.frameSequence.isActive();
                    this.rows = task.getRows();
                    this.frameRowCount = this.rows.size();
                    this.frameIndex = task.getFrameIndex();
                    this.frameRowIndex = 0L;
                    if (this.frameRowCount > 0L && this.frameSequence.isActive()) {
                        this.record.setFrameIndex(task.getFrameIndex());
                        break;
                    }
                    this.frameRowCount = 0L;
                    this.collectCursor(false);
                    continue;
                }
                Os.pause();
            } while (this.frameIndex < this.frameLimit);
        }
        catch (Throwable e) {
            LOG.critical().$("unexpected error [ex=").$(e).I$();
            throw CairoException.nonCritical().put(exceptionMessage).setInterruption(true);
        }
    }

    private long rowIndex() {
        return this.hasDescendingOrder ? this.frameRowCount - this.frameRowIndex - 1L : this.frameRowIndex;
    }

    void of(PageFrameSequence<?> frameSequence, long rowsRemaining) {
        this.isOpen = true;
        this.frameSequence = frameSequence;
        this.frameIndex = -1;
        this.frameLimit = frameSequence.getFrameCount() - 1;
        this.ogRowsRemaining = rowsRemaining;
        this.rowsRemaining = rowsRemaining;
        this.allFramesActive = true;
        this.record.of(frameSequence.getSymbolTableSource(), frameSequence.getPageAddressCache());
        if (this.recordB != null) {
            this.recordB.of(frameSequence.getSymbolTableSource(), frameSequence.getPageAddressCache());
        }
    }
}

