/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.wal.WalSqlExecutionContextImpl;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.bind.BindVariableServiceImpl;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.std.Misc;
import io.questdb.std.Rnd;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class OperationCompiler
implements Closeable {
    private final BindVariableService bindVariableService;
    private final Rnd rnd = new Rnd();
    private final SqlCompiler sqlCompiler;
    private final WalSqlExecutionContextImpl sqlExecutionContext;

    public OperationCompiler(CairoEngine engine, int workerCount, int sharedWorkerCount, @Nullable FunctionFactoryCache functionFactoryCache) {
        this.bindVariableService = new BindVariableServiceImpl(engine.getConfiguration());
        this.sqlExecutionContext = new WalSqlExecutionContextImpl(engine, workerCount, sharedWorkerCount);
        this.sqlExecutionContext.with(AllowAllCairoSecurityContext.INSTANCE, this.bindVariableService, this.rnd, -1L, null);
        this.sqlCompiler = new SqlCompiler(engine, functionFactoryCache, null);
    }

    @Override
    public void close() {
        Misc.free(this.sqlCompiler);
        Misc.free(this.sqlExecutionContext);
    }

    public AlterOperation compileAlterSql(CharSequence alterSql, TableToken tableToken) throws SqlException {
        this.sqlExecutionContext.remapTableNameResolutionTo(tableToken);
        CompiledQuery compiledQuery = this.sqlCompiler.compile(alterSql, this.sqlExecutionContext);
        AlterOperation alterOp = compiledQuery.getAlterOperation();
        alterOp.withContext(this.sqlExecutionContext);
        return alterOp;
    }

    public UpdateOperation compileUpdateSql(CharSequence updateSql, TableToken tableToken) throws SqlException {
        this.sqlExecutionContext.remapTableNameResolutionTo(tableToken);
        CompiledQuery compiledQuery = this.sqlCompiler.compile(updateSql, this.sqlExecutionContext);
        UpdateOperation updateOperation = compiledQuery.getUpdateOperation();
        updateOperation.withContext(this.sqlExecutionContext);
        return updateOperation;
    }

    public BindVariableService getBindVariableService() {
        return this.bindVariableService;
    }

    public void resetRnd(long seed0, long seed1) {
        this.rnd.reset(seed0, seed1);
    }

    public void setNowAndFixClock(long now) {
        this.sqlExecutionContext.setNowAndFixClock(now);
    }
}

