/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.properties.ApplicationProperties;
import org.apache.nifi.properties.ProtectedProperties;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProtector;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationPropertiesProtector<T extends ProtectedProperties<U>, U extends ApplicationProperties>
implements SensitivePropertyProtector<T, U> {
    public static final String PROTECTED_KEY_SUFFIX = ".protected";
    private static final Logger logger = LoggerFactory.getLogger(ApplicationPropertiesProtector.class);
    private final T protectedProperties;
    private final Map<String, SensitivePropertyProvider> localProviderCache = new HashMap<String, SensitivePropertyProvider>();

    public ApplicationPropertiesProtector(T protectedProperties) {
        this.protectedProperties = protectedProperties;
        logger.debug("Loaded {} properties (including {} protection schemes) into {}", new Object[]{this.getPropertyKeysIncludingProtectionSchemes().size(), this.getProtectedPropertyKeys().size(), this.getClass().getName()});
    }

    public static String getProtectionKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Cannot find protection key for null key");
        }
        return key + PROTECTED_KEY_SUFFIX;
    }

    public Set<String> getPropertyKeys() {
        Set<String> filteredKeys = this.getPropertyKeysIncludingProtectionSchemes();
        filteredKeys.removeIf(p -> p.endsWith(PROTECTED_KEY_SUFFIX));
        return filteredKeys;
    }

    public int size() {
        return this.getPropertyKeys().size();
    }

    public Set<String> getPropertyKeysIncludingProtectionSchemes() {
        return this.protectedProperties.getApplicationProperties().getPropertyKeys();
    }

    private static List<String> splitMultipleProperties(String multipleProperties) {
        if (multipleProperties == null || multipleProperties.trim().isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList(multipleProperties.split("\\s*[,;]\\s*")));
        for (int i = 0; i < properties.size(); ++i) {
            properties.set(i, ((String)properties.get(i)).trim());
        }
        return properties;
    }

    private String getProperty(String key) {
        return this.protectedProperties.getApplicationProperties().getProperty(key);
    }

    private String getAdditionalSensitivePropertiesKeys() {
        return this.getProperty(this.protectedProperties.getAdditionalSensitivePropertiesKeysName());
    }

    private String getAdditionalSensitivePropertiesKeysName() {
        return this.protectedProperties.getAdditionalSensitivePropertiesKeysName();
    }

    public List<String> getSensitivePropertyKeys() {
        String additionalPropertiesString = this.getAdditionalSensitivePropertiesKeys();
        String additionalPropertiesKeyName = this.protectedProperties.getAdditionalSensitivePropertiesKeysName();
        if (additionalPropertiesString == null || additionalPropertiesString.trim().isEmpty()) {
            return this.protectedProperties.getDefaultSensitiveProperties();
        }
        List<String> additionalProperties = ApplicationPropertiesProtector.splitMultipleProperties(additionalPropertiesString);
        if (additionalProperties.contains(additionalPropertiesKeyName)) {
            logger.warn("The key '{}' contains itself. This is poor practice and should be removed", (Object)additionalPropertiesKeyName);
            additionalProperties.remove(additionalPropertiesKeyName);
        }
        additionalProperties.addAll(this.protectedProperties.getDefaultSensitiveProperties());
        return additionalProperties;
    }

    public List<String> getPopulatedSensitivePropertyKeys() {
        List<String> allSensitiveKeys = this.getSensitivePropertyKeys();
        return allSensitiveKeys.stream().filter(k -> this.isNotBlank(this.getProperty((String)k))).collect(Collectors.toList());
    }

    public boolean hasProtectedKeys() {
        List<String> sensitiveKeys = this.getSensitivePropertyKeys();
        for (String k : sensitiveKeys) {
            if (!this.isPropertyProtected(k)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getProtectedPropertyKeys() {
        List<String> sensitiveKeys = this.getSensitivePropertyKeys();
        HashMap<String, String> traditionalProtectedProperties = new HashMap<String, String>();
        for (String key : sensitiveKeys) {
            String protection = this.getProperty(ApplicationPropertiesProtector.getProtectionKey(key));
            if (!this.isNotBlank(protection) || !this.isNotBlank(this.getProperty(key))) continue;
            traditionalProtectedProperties.put(key, protection);
        }
        return traditionalProtectedProperties;
    }

    public boolean isPropertySensitive(String key) {
        return key != null && !key.equals(this.getAdditionalSensitivePropertiesKeysName()) && this.getSensitivePropertyKeys().contains(key.trim());
    }

    public boolean isPropertyProtected(String key) {
        return key != null && this.isPropertySensitive(key) && this.isNotBlank(this.getProperty(ApplicationPropertiesProtector.getProtectionKey(key)));
    }

    public U getUnprotectedProperties() throws SensitivePropertyProtectionException {
        if (this.hasProtectedKeys()) {
            logger.debug("Protected Properties [{}] Sensitive Properties [{}]", (Object)this.getProtectedPropertyKeys().size(), (Object)this.getSensitivePropertyKeys().size());
            Properties rawProperties = new Properties();
            HashSet<String> failedKeys = new HashSet<String>();
            for (String key : this.getPropertyKeys()) {
                if (key.endsWith(PROTECTED_KEY_SUFFIX)) continue;
                if (this.isPropertyProtected(key)) {
                    try {
                        rawProperties.setProperty(key, this.unprotectValue(key, this.getProperty(key)));
                    }
                    catch (SensitivePropertyProtectionException e) {
                        logger.warn("Failed to unprotect '{}'", (Object)key, (Object)e);
                        failedKeys.add(key);
                    }
                    continue;
                }
                rawProperties.setProperty(key, this.getProperty(key));
            }
            if (!failedKeys.isEmpty()) {
                String failed = failedKeys.size() == 1 ? (String)failedKeys.iterator().next() : String.join((CharSequence)", ", failedKeys);
                throw new SensitivePropertyProtectionException(String.format("Failed unprotected properties: %s", failed));
            }
            return (U)this.protectedProperties.createApplicationProperties(rawProperties);
        }
        logger.debug("No protected properties");
        return (U)this.protectedProperties.getApplicationProperties();
    }

    public void addSensitivePropertyProvider(SensitivePropertyProvider sensitivePropertyProvider) {
        Objects.requireNonNull(sensitivePropertyProvider, "Provider required");
        String identifierKey = sensitivePropertyProvider.getIdentifierKey();
        if (this.localProviderCache.containsKey(identifierKey)) {
            throw new UnsupportedOperationException(String.format("Sensitive Property Provider Identifier [%s] override not supported", identifierKey));
        }
        this.localProviderCache.put(identifierKey, sensitivePropertyProvider);
    }

    public String toString() {
        return String.format("%s Properties [%d]", this.getClass().getSimpleName(), this.getPropertyKeys().size());
    }

    private String unprotectValue(String key, String retrievedValue) {
        if (this.isPropertyProtected(key)) {
            String protectionSchemePath = this.getProperty(ApplicationPropertiesProtector.getProtectionKey(key));
            try {
                SensitivePropertyProvider provider = this.findProvider(protectionSchemePath);
                return provider.unprotect(retrievedValue, ProtectedPropertyContext.defaultContext((String)key));
            }
            catch (RuntimeException e) {
                throw new SensitivePropertyProtectionException(String.format("Property [%s] unprotect failed", key), (Throwable)e);
            }
        }
        return retrievedValue;
    }

    private SensitivePropertyProvider findProvider(String protectionSchemePath) {
        Objects.requireNonNull(protectionSchemePath, "Protection Scheme Path required");
        return this.localProviderCache.entrySet().stream().filter(entry -> protectionSchemePath.startsWith((String)entry.getKey())).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new UnsupportedOperationException(String.format("Protection Scheme Path [%s] Provider not found", protectionSchemePath)));
    }

    private boolean isNotBlank(String string) {
        return string != null && string.length() > 0;
    }
}

