/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.NoSuchElementException;
import jetbrains.exodus.core.dataStructures.persistent.PersistentStack;
import org.jetbrains.annotations.NotNull;

public class PersistentQueue<T> {
    public static final PersistentQueue EMPTY = new PersistentQueue();
    @NotNull
    private final PersistentStack<T> incoming;
    @NotNull
    private final PersistentStack<T> outgoing;

    private PersistentQueue() {
        this.incoming = PersistentStack.EMPTY_STACK;
        this.outgoing = PersistentStack.EMPTY_STACK;
    }

    private PersistentQueue(@NotNull PersistentStack<T> in, @NotNull PersistentStack<T> out) {
        this.incoming = in;
        this.outgoing = out;
    }

    public int size() {
        return this.incoming.size() + this.outgoing.size();
    }

    public PersistentQueue<T> add(T element) {
        if (this.isEmpty()) {
            return new PersistentQueue<T>(PersistentStack.EMPTY_STACK, PersistentStack.EMPTY_STACK.push(element));
        }
        return new PersistentQueue<T>(this.incoming.push(element), this.outgoing);
    }

    public boolean isEmpty() {
        return this.outgoing.isEmpty();
    }

    public T peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.outgoing.peek();
    }

    public PersistentQueue<T> skip() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        PersistentStack<T> out = this.outgoing.skip();
        if (out.isEmpty()) {
            return new PersistentQueue<T>(PersistentStack.EMPTY_STACK, this.incoming.reverse());
        }
        return new PersistentQueue<T>(this.incoming, out);
    }

    public int hashCode() {
        return this.incoming.hashCode() + this.outgoing.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersistentQueue)) {
            return false;
        }
        PersistentQueue queue = (PersistentQueue)obj;
        return this.incoming.equals(queue.incoming) && this.outgoing.equals(queue.outgoing);
    }
}

