/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.nifi.repository.encryption.RepositoryEncryptionException;
import org.apache.nifi.repository.encryption.RepositoryEncryptor;
import org.apache.nifi.repository.encryption.configuration.EncryptionMetadataHeader;
import org.apache.nifi.repository.encryption.configuration.EncryptionProtocol;
import org.apache.nifi.repository.encryption.configuration.RepositoryEncryptionMethod;
import org.apache.nifi.repository.encryption.metadata.RecordMetadata;
import org.apache.nifi.repository.encryption.metadata.RecordMetadataSerializer;
import org.apache.nifi.repository.encryption.metadata.serialization.RecordMetadataObjectInputStream;
import org.apache.nifi.repository.encryption.metadata.serialization.StandardRecordMetadataSerializer;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.stream.io.NonCloseableInputStream;

public abstract class AesSecretKeyRepositoryEncryptor<I, O>
implements RepositoryEncryptor<I, O> {
    private static final int INITIALIZATION_VECTOR_LENGTH = 16;
    private static final int TAG_LENGTH = 128;
    private static final int END_OF_STREAM = -1;
    private static final int STREAM_LENGTH = -1;
    private static final RecordMetadataSerializer RECORD_METADATA_SERIALIZER = new StandardRecordMetadataSerializer(EncryptionProtocol.VERSION_1);
    private final SecureRandom secureRandom;
    private final KeyProvider keyProvider;
    private final EncryptionMetadataHeader encryptionMetadataHeader;
    private final RepositoryEncryptionMethod repositoryEncryptionMethod;

    AesSecretKeyRepositoryEncryptor(RepositoryEncryptionMethod repositoryEncryptionMethod, KeyProvider keyProvider, EncryptionMetadataHeader encryptionMetadataHeader) {
        this.repositoryEncryptionMethod = Objects.requireNonNull(repositoryEncryptionMethod, "Encryption Method required");
        this.keyProvider = Objects.requireNonNull(keyProvider, "Key Provider required");
        this.encryptionMetadataHeader = Objects.requireNonNull(encryptionMetadataHeader, "Encryption Metadata Header required");
        this.secureRandom = new SecureRandom();
    }

    @Override
    public I encrypt(I record, String recordId, String keyId) {
        Objects.requireNonNull(record, "Record required");
        Objects.requireNonNull(recordId, "Record ID required");
        Objects.requireNonNull(keyId, "Key ID required");
        Cipher cipher = this.getEncryptionCipher(keyId);
        return this.encrypt(record, recordId, keyId, cipher);
    }

    protected abstract I encrypt(I var1, String var2, String var3, Cipher var4);

    protected Cipher getEncryptionCipher(String keyId) {
        byte[] initializationVector = this.getInitializationVector();
        return this.getCipher(1, keyId, initializationVector);
    }

    protected Cipher getDecryptionCipher(String keyId, byte[] initializationVector) {
        return this.getCipher(2, keyId, initializationVector);
    }

    protected byte[] getMetadata(String keyId, byte[] initializationVector, int cipherLength) {
        return this.writeMetadata(keyId, initializationVector, cipherLength);
    }

    protected byte[] getMetadata(String keyId, byte[] initializationVector) {
        return this.writeMetadata(keyId, initializationVector, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RecordMetadata readMetadata(InputStream inputStream) {
        int headerLength = this.encryptionMetadataHeader.getLength();
        try {
            int headerBytesRead = inputStream.read(new byte[headerLength]);
            if (-1 == headerBytesRead) {
                throw new RepositoryEncryptionException("End of InputStream while reading metadata header");
            }
        }
        catch (IOException e) {
            throw new RepositoryEncryptionException(String.format("Read Metadata Header bytes [%d] failed", headerLength), e);
        }
        try (RecordMetadataObjectInputStream objectInputStream = new RecordMetadataObjectInputStream((InputStream)new NonCloseableInputStream(inputStream));){
            RecordMetadata recordMetadata = objectInputStream.getRecordMetadata();
            return recordMetadata;
        }
        catch (IOException e) {
            throw new RepositoryEncryptionException("Read Encryption Metadata Failed", e);
        }
    }

    private byte[] writeMetadata(String keyId, byte[] initializationVector, int cipherLength) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(this.encryptionMetadataHeader.getHeader());
            byte[] metadata = RECORD_METADATA_SERIALIZER.writeMetadata(keyId, initializationVector, cipherLength, this.repositoryEncryptionMethod);
            outputStream.write(metadata);
        }
        catch (IOException e) {
            throw new RepositoryEncryptionException("Write Encryption Metadata Failed", e);
        }
        return outputStream.toByteArray();
    }

    private byte[] getInitializationVector() {
        byte[] initializationVector = new byte[16];
        this.secureRandom.nextBytes(initializationVector);
        return initializationVector;
    }

    private Cipher getCipher(int mode, String keyId, byte[] initializationVector) {
        SecretKey secretKey = this.getSecretKey(keyId);
        String algorithm = this.repositoryEncryptionMethod.getAlgorithm();
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            AlgorithmParameterSpec algorithmParameterSpec = this.getAlgorithmParametersSpec(initializationVector);
            cipher.init(mode, (Key)secretKey, algorithmParameterSpec, this.secureRandom);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            String message = String.format("Cipher [%s] Mode [%d] Key ID [%s] configuration failed", algorithm, mode, keyId);
            throw new RepositoryEncryptionException(message, e);
        }
    }

    private AlgorithmParameterSpec getAlgorithmParametersSpec(byte[] initializationVector) {
        if (RepositoryEncryptionMethod.AES_GCM == this.repositoryEncryptionMethod) {
            return new GCMParameterSpec(128, initializationVector);
        }
        return new IvParameterSpec(initializationVector);
    }

    private SecretKey getSecretKey(String keyId) {
        if (this.keyProvider.keyExists(keyId)) {
            try {
                return this.keyProvider.getKey(keyId);
            }
            catch (KeyManagementException e) {
                throw new RepositoryEncryptionException(String.format("Key ID [%s] retrieval failed", keyId), e);
            }
        }
        throw new RepositoryEncryptionException(String.format("Key ID [%s] not found", keyId));
    }
}

